/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public abstract class AbstractFunctionCall
extends Expression {
    private final List<Expression> arguments = new ArrayList<Expression>();

    public AbstractFunctionCall(Expression ... args) {
        this.arguments.addAll(Arrays.asList(args));
    }

    public void addArgument(Expression arg) {
        this.arguments.add(arg);
    }

    public boolean hasArguments() {
        return !this.arguments.isEmpty();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Precedence02;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Expression expr : this.arguments) {
            if (expr.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!fmt.write('(')) {
            return false;
        }
        boolean first = true;
        for (Expression arg : this.arguments) {
            if (first) {
                first = false;
            } else if (!fmt.write(',')) {
                return false;
            }
            if (fmt.space() && arg.write(fmt)) continue;
            return false;
        }
        return fmt.spaceUnless('(') && fmt.write(')');
    }
}

