/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ExpressionStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.VariableDeclarationStatement;

public class CodeBlock
extends Statement {
    private boolean forceBraces;
    private final List<Statement> statements = new ArrayList<Statement>();

    public static CodeBlock defaultBraces() {
        return new CodeBlock(false);
    }

    public static CodeBlock forceBraces() {
        return new CodeBlock(true);
    }

    public CodeBlock(Statement ... stmts) {
        this(false);
        this.statements.addAll(Arrays.asList(stmts));
    }

    protected CodeBlock(boolean braces) {
        this.forceBraces = braces;
    }

    public void setForceBraces() {
        this.forceBraces = true;
    }

    public boolean isForceBraces() {
        return this.forceBraces;
    }

    public void add(Statement ... stmts) {
        this.add(Arrays.asList(stmts));
    }

    public void add(List<Statement> stmts) {
        this.statements.addAll(stmts);
    }

    public void add(Expression expr) {
        this.add(new ExpressionStatement(expr));
    }

    public void add(Variable var) {
        this.add(new VariableDeclarationStatement(var));
    }

    public Iterable<Statement> getStatements() {
        return this.statements;
    }

    public Statement getLast() {
        return this.statements.size() <= 0 ? null : this.statements.get(this.statements.size() - 1);
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Statement stmt : this.statements) {
            if (stmt.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        boolean useBraces;
        boolean bl = useBraces = this.forceBraces || this.statements.size() != 1;
        if (useBraces && !fmt.openBrace() || !useBraces && !fmt.incIndent()) {
            return false;
        }
        for (Statement stmt : this.statements) {
            if (stmt.write(fmt)) continue;
            fmt.decIndent();
            return false;
        }
        return useBraces ? fmt.closeBrace() : fmt.decIndent();
    }
}

