/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.standalone;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrusrt.codegen.utils.PluginFinder;
import org.eclipse.uml2.uml.UMLPlugin;

public abstract class RegisteredPackageMetadata {
    public static final PluginFinder pluginFinder = new PluginFinder(new String[0]);

    public abstract String getPackageId();

    public abstract String getNS_URI();

    public abstract EPackage getPackage();

    public abstract String getPathmap();

    public abstract String getRootId();

    public abstract String getRootURI();

    public abstract String getPackageSubdirectory();

    public abstract String getPackageModel();

    public void registerProfile(ResourceSet resourceSet) {
        String ns_uri = this.getNS_URI();
        EPackage pkg = this.getPackage();
        String root_uri = this.getRootURI();
        if (ns_uri != null && pkg != null) {
            resourceSet.getPackageRegistry().put((Object)ns_uri, (Object)pkg);
        }
        if (ns_uri != null && root_uri != null) {
            UMLPlugin.getEPackageNsURIToProfileLocationMap().put(ns_uri, URI.createURI((String)root_uri));
        }
        this.registerPackage(resourceSet);
    }

    public void registerPackage(ResourceSet resourceSet) {
        String pathmap = this.getPathmap();
        String loc = this.getPackageLocation();
        if (pathmap != null && loc != null) {
            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)pathmap), URI.createURI((String)loc));
        }
    }

    public void registerPackage(ResourceSet resourceSet, EPackage pkg) {
        String ns_uri = this.getNS_URI();
        if (ns_uri != null && pkg != null) {
            resourceSet.getPackageRegistry().put((Object)ns_uri, (Object)pkg);
        }
        this.registerPackage(resourceSet);
    }

    public static void searchPlugins(String ... pkgIds) {
        String[] stringArray = pkgIds;
        int n = pkgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgId = stringArray[n2];
            pluginFinder.addRequiredPlugin(pkgId);
            ++n2;
        }
        pluginFinder.resolve();
        pluginFinder.logResolvedMappings();
    }

    public String getPackageLocation() {
        String pkgId = this.getPackageId();
        if (pkgId == null) {
            return null;
        }
        String packageLoc = pluginFinder.get(pkgId);
        if (packageLoc != null) {
            String pkgModel;
            Path path = Paths.get(packageLoc, new String[0]);
            String subdir = this.getPackageSubdirectory();
            if (subdir != null) {
                path = path.resolve(subdir);
            }
            if ((pkgModel = this.getPackageModel()) != null) {
                path = path.resolve(pkgModel);
            }
            return path.toString();
        }
        return null;
    }

    public URI getPathmapURI() {
        return URI.createURI((String)this.getPathmap());
    }

    public URI getPackageLocationURI() {
        return URI.createURI((String)this.getPackageLocation());
    }
}

