/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.standalone;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.CppProjectGenerator;
import org.eclipse.papyrusrt.codegen.standalone.StandaloneUMLRTCodeGenerator;
import org.eclipse.papyrusrt.codegen.utils.CodeGenUtils;
import org.eclipse.papyrusrt.codegen.utils.ProjectUtils;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.UML2xtumlrtModelTranslator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;

public class UMLRTGenerator {
    private static Path commonOutputPath;
    private static UML2xtumlrtModelTranslator translator;
    private static CppCodePattern cpp;
    private static CppCodeGenerator codegen;

    static {
        translator = new UML2xtumlrtModelTranslator();
        cpp = new CppCodePattern(translator);
        codegen = new CppCodeGenerator(cpp);
    }

    public static IStatus generate(List<EObject> elements, String top) {
        Class topCapsule = CodeGenUtils.findCapsule((EObject)elements.get(0), (String)top);
        codegen.setTop(topCapsule);
        cpp.setTop(topCapsule);
        HashMap<File, ArrayList<EObject>> targets = new HashMap<File, ArrayList<EObject>>();
        HashMap<File, Object> outputFolders = new HashMap<File, Object>();
        for (EObject eobj : elements) {
            File modelFolder = StandaloneUMLRTCodeGenerator.getModelPath().getParent().toFile();
            ArrayList<EObject> list = (ArrayList<EObject>)targets.get(modelFolder);
            if (list == null) {
                list = new ArrayList<EObject>();
                targets.put(modelFolder, list);
            }
            list.add(eobj);
            Object outputFolder = (File)outputFolders.get(modelFolder);
            if (outputFolder != null) continue;
            outputFolder = UMLRTGenerator.getOutputFolder(eobj);
            outputFolders.put(modelFolder, outputFolder);
        }
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT code generator invoked", null);
        long start = System.currentTimeMillis();
        if (targets.isEmpty()) {
            status.add(CodeGenPlugin.error((String)"Selection must contain at least one model element"));
        } else {
            try {
                for (Map.Entry entry : targets.entrySet()) {
                    File modelFolder = (File)entry.getKey();
                    Path path = modelFolder.toPath();
                    File outputFolder = (File)outputFolders.get(modelFolder);
                    translator.setTargets((List)entry.getValue());
                    translator.setOutputPath(path);
                    status.addAll(translator.generate());
                    List translated = translator.getAllGenerated();
                    if (translated == null || translated.isEmpty()) continue;
                    cpp.setOutputFolder(outputFolder);
                    cpp.setModelFolder(modelFolder);
                    codegen.setTargets(translated);
                    status.addAll(codegen.generate());
                    long writeStart = System.currentTimeMillis();
                    if (cpp.write()) {
                        status.add(CodeGenPlugin.info((String)("Updated generated files " + (System.currentTimeMillis() - writeStart) + "ms")));
                        continue;
                    }
                    status.add(CodeGenPlugin.error((String)"Failed to write generated model to disk"));
                }
            }
            catch (Throwable t) {
                CodeGenPlugin.error((String)"error during codegen action", (Throwable)t);
                status.add(CodeGenPlugin.error((Throwable)t));
            }
        }
        String message = "Generation " + (status.getSeverity() <= 1 ? "complete" : "error") + ", elapsed time " + (System.currentTimeMillis() - start) + " ms";
        CodeGenPlugin.info((String)message);
        MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, message, null);
        result.addAll((IStatus)status);
        return result;
    }

    public static IStatus generateXTUMLRT(Model model) {
        File folder = UMLRTGenerator.getOutputFolder((EObject)model);
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML2-to-xtUMLrt Translator Invoked", null);
        long start = System.currentTimeMillis();
        if (model == null) {
            status.add(CodeGenPlugin.error((String)"No input model given"));
        } else {
            try {
                ArrayList<Model> targets = new ArrayList<Model>();
                targets.add(model);
                UML2xtumlrtModelTranslator translator = new UML2xtumlrtModelTranslator(targets, folder.toPath());
                status.addAll(translator.generate());
                long writeStart = System.currentTimeMillis();
                if (translator.write()) {
                    status.add(CodeGenPlugin.info((String)("Updated generated files " + (System.currentTimeMillis() - writeStart) + "ms")));
                } else {
                    status.add(CodeGenPlugin.error((String)"Failed to write generated model to disk"));
                }
            }
            catch (Throwable t) {
                CodeGenPlugin.error((String)"error during translation action", (Throwable)t);
                status.add(CodeGenPlugin.error((Throwable)t));
            }
        }
        String message = "Translation " + (status.getSeverity() <= 1 ? "complete" : "error") + ", elapsed time " + (System.currentTimeMillis() - start) + " ms";
        CodeGenPlugin.info((String)message);
        MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, message, null);
        result.addAll((IStatus)status);
        return result;
    }

    private static File getOutputFolder(EObject eobj) {
        if (commonOutputPath != null) {
            return commonOutputPath.toFile();
        }
        Path outputPath = StandaloneUMLRTCodeGenerator.getOutputPath();
        if (outputPath != null) {
            File project = outputPath.toFile();
            if (project.exists()) {
                try {
                    RecursiveFileRemover visitor = new RecursiveFileRemover();
                    Files.walkFileTree(outputPath, visitor);
                }
                catch (IOException iOException) {
                    CodeGenPlugin.error((String)"Failed to delete the previously generated project");
                }
            }
            if (!project.exists() && !project.mkdirs()) {
                CodeGenPlugin.error((String)"Failed to create project");
                return null;
            }
            String projectName = project.getName();
            String projectPath = project.getParentFile().getPath();
            if (!new CppProjectGenerator().generate(projectPath, projectName)) {
                CodeGenPlugin.error((String)"Failed to create project");
                return null;
            }
            File src = new File(project, "src");
            if (!src.exists() && !src.mkdir()) {
                CodeGenPlugin.error((String)"Failed to create source folder");
                return null;
            }
            commonOutputPath = src.toPath();
            return src;
        }
        URI uri = eobj.eResource().getURI();
        String projectName = ProjectUtils.getProjectName((EObject)eobj);
        projectName = String.valueOf(projectName) + "_CDTProject";
        Path elementPath = Paths.get(uri.path(), new String[0]);
        Path projectPath = elementPath.getParent().resolveSibling(projectName);
        if (!new CppProjectGenerator().generate(projectPath.getParent().toString(), projectName)) {
            CodeGenPlugin.error((String)"Failed to create project");
            return null;
        }
        File project = projectPath.toFile();
        File src = new File(project, "src");
        if (!src.exists() && !src.mkdir()) {
            CodeGenPlugin.error((String)"Failed to create source folder");
            return null;
        }
        return src;
    }

    private static class RecursiveFileRemover
    implements FileVisitor<Path> {
        private RecursiveFileRemover() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

