/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.codegen.utils.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeature;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeatureKind;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StateMachine;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.common.VisibilityKind;
import org.eclipse.papyrusrt.xtumlrt.umlrt.PortRegistration;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class XTUMLRTUtil {
    public static final String RTS_LIBRARY_NAME = "UML-RT RTS Model Library";
    public static final URI RTS_LIBRARY_URI = URI.createURI((String)"pathmap://UMLRTRTSLIB/UMLRT-RTS.uml#_mPjAgGXmEeS_4daqvwyFrg");
    public static final String RTS_LIBRARY_URI_STR = RTS_LIBRARY_URI.toPlatformString(false);

    public static StateMachine getActualBehaviour(Capsule capsule) {
        StateMachine _xblockexpression = null;
        StateMachine stateMachine = null;
        if (capsule != null) {
            boolean _tripleNotEquals;
            StateMachine _behaviour = capsule.getBehaviour();
            boolean bl = _tripleNotEquals = _behaviour != null;
            if (_tripleNotEquals) {
                StateMachine _behaviour_1;
                stateMachine = _behaviour_1 = capsule.getBehaviour();
            } else {
                boolean _tripleNotEquals_1;
                boolean _and = false;
                RedefinableElement _redefines = capsule.getRedefines();
                boolean bl2 = _tripleNotEquals_1 = _redefines != null;
                if (!_tripleNotEquals_1) {
                    _and = false;
                } else {
                    RedefinableElement _redefines_1 = capsule.getRedefines();
                    _and = _redefines_1 instanceof Capsule;
                }
                if (_and) {
                    StateMachine _actualBehaviour;
                    RedefinableElement _redefines_2 = capsule.getRedefines();
                    stateMachine = _actualBehaviour = XTUMLRTUtil.getActualBehaviour((Capsule)_redefines_2);
                }
            }
        }
        _xblockexpression = stateMachine;
        return _xblockexpression;
    }

    protected static Iterable<Capsule> _getAllCapsules(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> set = new TreeSet<NamedElement>(_nameComparator);
        EList _entities = model.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        EList _packages = model.getPackages();
        for (Package pkg : _packages) {
            Iterable<Capsule> _allCapsules = XTUMLRTUtil.getAllCapsules((EObject)pkg);
            Iterables.addAll(set, _allCapsules);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    protected static Iterable<Capsule> _getAllCapsules(Package packge) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> set = new TreeSet<NamedElement>(_nameComparator);
        EList _entities = packge.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        _xblockexpression = set;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getAllCapsuleParts(final Capsule capsule) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> allParts = new TreeSet<NamedElement>(_nameComparator);
        if (capsule != null) {
            EList _parts = capsule.getParts();
            allParts.addAll((Collection<NamedElement>)_parts);
            RedefinableElement parentElement = capsule.getRedefines();
            boolean _and = false;
            _and = parentElement == null ? false : parentElement instanceof Capsule;
            if (_and) {
                Capsule parent = (Capsule)parentElement;
                Iterable<CapsulePart> _allCapsuleParts = XTUMLRTUtil.getAllCapsuleParts(parent);
                Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

                    public Boolean apply(CapsulePart it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allCapsuleParts, (Functions.Function1)_function);
                Iterables.addAll(allParts, (Iterable)_filter);
            }
        }
        _xblockexpression = allParts;
        return _xblockexpression;
    }

    public static Iterable<Connector> getAllConnectors(Capsule capsule) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> allConnectors = new TreeSet<NamedElement>(_nameComparator);
        if (capsule != null) {
            EList _connectors = capsule.getConnectors();
            allConnectors.addAll((Collection<NamedElement>)_connectors);
            RedefinableElement parentElement = capsule.getRedefines();
            boolean _and = false;
            _and = parentElement == null ? false : parentElement instanceof Capsule;
            if (_and) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Connector> _allConnectors = XTUMLRTUtil.getAllConnectors(parent);
                Iterables.addAll(allConnectors, _allConnectors);
            }
        }
        _xblockexpression = allConnectors;
        return _xblockexpression;
    }

    public static Iterable<Port> getAllRTPorts(final Capsule capsule) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> allPorts = new TreeSet<NamedElement>(_nameComparator);
        if (capsule != null) {
            Iterable<Port> _rTPorts = XTUMLRTUtil.getRTPorts(capsule);
            Iterables.addAll(allPorts, _rTPorts);
            RedefinableElement parentElement = capsule.getRedefines();
            boolean _and = false;
            _and = parentElement == null ? false : parentElement instanceof Capsule;
            if (_and) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Port> _allRTPorts = XTUMLRTUtil.getAllRTPorts(parent);
                Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                    public Boolean apply(Port it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allRTPorts, (Functions.Function1)_function);
                Iterables.addAll(allPorts, (Iterable)_filter);
            }
        }
        _xblockexpression = allPorts;
        return _xblockexpression;
    }

    public static Iterable<Signal> getAllSignals(final Protocol protocol) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> allSignals = new TreeSet<NamedElement>(_nameComparator);
        if (protocol != null) {
            Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
            Iterables.addAll(allSignals, _signals);
            RedefinableElement parentElement = protocol.getRedefines();
            boolean _and = false;
            _and = parentElement == null ? false : parentElement instanceof Capsule;
            if (_and) {
                Protocol parent = (Protocol)parentElement;
                Iterable<Signal> _allSignals = XTUMLRTUtil.getAllSignals(parent);
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)protocol, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
                Iterables.addAll(allSignals, (Iterable)_filter);
            }
        }
        _xblockexpression = allSignals;
        return _xblockexpression;
    }

    public static Iterable<Signal> getAllUserSignals(Protocol protocol) {
        Iterable<Signal> _allSignals = XTUMLRTUtil.getAllSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = XTUMLRTUtil.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getCapsuleParts(Capsule capsule) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> parts = new TreeSet<NamedElement>(_nameComparator);
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                Capsule _type = it.getType();
                return _type != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
        Iterables.addAll(parts, (Iterable)_filter);
        _xblockexpression = parts;
        return _xblockexpression;
    }

    public static Iterable<Signal> getInSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                boolean _and = false;
                if (!(it instanceof Signal)) {
                    _and = false;
                } else {
                    boolean _equals;
                    ProtocolBehaviourFeatureKind _kind = it.getKind();
                    _and = _equals = Objects.equal((Object)_kind, (Object)ProtocolBehaviourFeatureKind.IN);
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static Iterable<Signal> getInOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                boolean _and = false;
                if (!(it instanceof Signal)) {
                    _and = false;
                } else {
                    boolean _equals;
                    ProtocolBehaviourFeatureKind _kind = it.getKind();
                    _and = _equals = Objects.equal((Object)_kind, (Object)ProtocolBehaviourFeatureKind.INOUT);
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static <T extends MultiplicityElement & NamedElement> int getLowerBound(T element) {
        boolean _isPublish;
        boolean _and = false;
        _and = !(element instanceof RTPort) ? false : (_isPublish = ((RTPort)element).isPublish());
        if (_and) {
            return 0;
        }
        int bound = element.getLowerBound();
        if (bound < 0) {
            String _fullName = QualifiedNames.fullName(element);
            String _plus = "lower bound must be specified for " + _fullName;
            throw new RuntimeException(_plus);
        }
        return bound;
    }

    public static Iterable<Signal> getOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                boolean _and = false;
                if (!(it instanceof Signal)) {
                    _and = false;
                } else {
                    boolean _equals;
                    ProtocolBehaviourFeatureKind _kind = it.getKind();
                    _and = _equals = Objects.equal((Object)_kind, (Object)ProtocolBehaviourFeatureKind.OUT);
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static NamedElement getOwner(CommonElement element) {
        boolean _tripleEquals;
        NamedElement _xifexpression = null;
        EObject _eContainer = element.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            EObject _eContainer_1 = element.eContainer();
            _xifexpression = (NamedElement)_eContainer_1;
        }
        return _xifexpression;
    }

    public static org.eclipse.papyrusrt.xtumlrt.common.Model getModel(CommonElement element) {
        org.eclipse.papyrusrt.xtumlrt.common.Model _xblockexpression = null;
        CommonElement elem = element;
        while (elem != null && !(elem instanceof org.eclipse.papyrusrt.xtumlrt.common.Model) && XTUMLRTUtil.getOwner(elem) != null) {
            NamedElement _owner = XTUMLRTUtil.getOwner(elem);
            elem = _owner;
        }
        _xblockexpression = (org.eclipse.papyrusrt.xtumlrt.common.Model)elem;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getPartRedefinitions(Capsule capsule) {
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                boolean _tripleNotEquals;
                boolean _and = false;
                RedefinableElement _redefines = it.getRedefines();
                boolean bl = _tripleNotEquals = _redefines != null;
                if (!_tripleNotEquals) {
                    _and = false;
                } else {
                    RedefinableElement _redefines_1 = it.getRedefines();
                    _and = _redefines_1 instanceof CapsulePart;
                }
                return _and;
            }
        };
        return IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
    }

    public static Iterable<Port> getPortRedefinitions(Capsule capsule) {
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                boolean _tripleNotEquals;
                boolean _and = false;
                RedefinableElement _redefines = it.getRedefines();
                boolean bl = _tripleNotEquals = _redefines != null;
                if (!_tripleNotEquals) {
                    _and = false;
                } else {
                    RedefinableElement _redefines_1 = it.getRedefines();
                    _and = _redefines_1 instanceof Port;
                }
                return _and;
            }
        };
        return IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getSignalRedefinitions(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _tripleNotEquals;
                boolean _and = false;
                RedefinableElement _redefines = it.getRedefines();
                boolean bl = _tripleNotEquals = _redefines != null;
                if (!_tripleNotEquals) {
                    _and = false;
                } else {
                    RedefinableElement _redefines_1 = it.getRedefines();
                    _and = _redefines_1 instanceof Signal;
                }
                return _and;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getRedefinedParts(Capsule capsule) {
        Iterable<CapsulePart> _partRedefinitions = XTUMLRTUtil.getPartRedefinitions(capsule);
        Functions.Function1<CapsulePart, CapsulePart> _function = new Functions.Function1<CapsulePart, CapsulePart>(){

            public CapsulePart apply(CapsulePart it) {
                RedefinableElement _redefines = it.getRedefines();
                return (CapsulePart)_redefines;
            }
        };
        return IterableExtensions.map(_partRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRedefinedPorts(Capsule capsule) {
        Iterable<Port> _portRedefinitions = XTUMLRTUtil.getPortRedefinitions(capsule);
        Functions.Function1<Port, Port> _function = new Functions.Function1<Port, Port>(){

            public Port apply(Port it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Port)_redefines;
            }
        };
        return IterableExtensions.map(_portRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getRedefinedSignals(Protocol protocol) {
        Iterable<Signal> _signalRedefinitions = XTUMLRTUtil.getSignalRedefinitions(protocol);
        Functions.Function1<Signal, Signal> _function = new Functions.Function1<Signal, Signal>(){

            public Signal apply(Signal it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Signal)_redefines;
            }
        };
        return IterableExtensions.map(_signalRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRTPorts(Capsule capsule) {
        TreeSet<NamedElement> _xblockexpression = null;
        NameComparator _nameComparator = new NameComparator();
        TreeSet<NamedElement> ports = new TreeSet<NamedElement>(_nameComparator);
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                Protocol _type = it.getType();
                return _type != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
        Iterables.addAll(ports, (Iterable)_filter);
        _xblockexpression = ports;
        return _xblockexpression;
    }

    public static Iterable<StructuredType> getSupertypes(StructuredType type) {
        EList _generalizations = type.getGeneralizations();
        List _map = null;
        if (_generalizations != null) {
            Functions.Function1<Generalization, StructuredType> _function = new Functions.Function1<Generalization, StructuredType>(){

                public StructuredType apply(Generalization it) {
                    return it.getSuper();
                }
            };
            _map = ListExtensions.map((List)_generalizations, (Functions.Function1)_function);
        }
        return _map;
    }

    public static Iterable<Signal> getSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static Iterable<Signal> getUserSignals(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                boolean _isSystemElement = XTUMLRTUtil.isSystemElement((CommonElement)it);
                return !_isSystemElement;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }

    public static <T extends MultiplicityElement & NamedElement> int getUpperBound(T element) {
        int bound = element.getUpperBound();
        if (bound < 0) {
            String _fullName = QualifiedNames.fullName(element);
            String _plus = "upper bound must be specified for " + _fullName;
            throw new RuntimeException(_plus);
        }
        return bound;
    }

    public static boolean isInternalPort(Port port) {
        boolean _isWired;
        boolean _not;
        boolean _notEquals;
        boolean _or = false;
        VisibilityKind _visibility = port.getVisibility();
        boolean bl = _notEquals = !Objects.equal((Object)_visibility, (Object)VisibilityKind.PUBLIC);
        _or = _notEquals ? true : (_not = !(_isWired = XTUMLRTUtil.isWired(port)));
        return _or;
    }

    public static boolean isWired(Port port) {
        boolean _isWired;
        boolean _and = false;
        _and = !(port instanceof RTPort) ? false : (_isWired = ((RTPort)port).isWired());
        return _and;
    }

    public static boolean isAutomatic(Port port) {
        boolean _and = false;
        if (!(port instanceof RTPort)) {
            _and = false;
        } else {
            boolean _equals;
            PortRegistration _registration = ((RTPort)port).getRegistration();
            _and = _equals = Objects.equal((Object)_registration, (Object)PortRegistration.AUTOMATIC);
        }
        return _and;
    }

    public static boolean isApplicationLocked(Port port) {
        boolean _and = false;
        if (!(port instanceof RTPort)) {
            _and = false;
        } else {
            boolean _equals;
            PortRegistration _registration = ((RTPort)port).getRegistration();
            _and = _equals = Objects.equal((Object)_registration, (Object)PortRegistration.APPLICATIONLOCKED);
        }
        return _and;
    }

    public static boolean isNotification(Port port) {
        boolean _isNotification;
        boolean _and = false;
        _and = !(port instanceof RTPort) ? false : (_isNotification = ((RTPort)port).isNotification());
        return _and;
    }

    public static boolean isPublish(Port port) {
        boolean _isPublish;
        boolean _and = false;
        _and = !(port instanceof RTPort) ? false : (_isPublish = ((RTPort)port).isPublish());
        return _and;
    }

    public static String getRegistrationOverride(Port port) {
        String _xifexpression = null;
        _xifexpression = !(port instanceof RTPort) ? null : ((RTPort)port).getRegistrationOverride();
        return _xifexpression;
    }

    public static <T extends MultiplicityElement & NamedElement> boolean isReplicated(T element) {
        int _upperBound;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _or = false;
        int _lowerBound = element.getLowerBound();
        boolean bl = _notEquals = _lowerBound != 1;
        _or = _notEquals ? true : (_notEquals_1 = (_upperBound = element.getUpperBound()) != 1);
        return _or;
    }

    private static boolean _redefines(Capsule capsule, final Port port) {
        Iterable<Port> _redefinedPorts = XTUMLRTUtil.getRedefinedPorts(capsule);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it, (Object)port);
            }
        };
        return IterableExtensions.exists(_redefinedPorts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final CapsulePart part) {
        Iterable<CapsulePart> _redefinedParts = XTUMLRTUtil.getRedefinedParts(capsule);
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it, (Object)part);
            }
        };
        return IterableExtensions.exists(_redefinedParts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Protocol protocol, final Signal signal) {
        Iterable<Signal> _redefinedSignals = XTUMLRTUtil.getRedefinedSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return Objects.equal((Object)it, (Object)signal);
            }
        };
        return IterableExtensions.exists(_redefinedSignals, (Functions.Function1)_function);
    }

    public static boolean isRTSModelLibrary(org.eclipse.uml2.uml.Package packge) {
        boolean _equals_1;
        boolean _isModelLibrary;
        boolean _xblockexpression = false;
        Resource _eResource = packge.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        URIConverter uriConverter = _resourceSet.getURIConverter();
        URI packageURI = EcoreUtil.getURI((EObject)packge);
        URI normalizedPackageURI = uriConverter.normalize(packageURI);
        URI normalizedRTSLibURI = uriConverter.normalize(RTS_LIBRARY_URI);
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        if (!(packge instanceof Model)) {
            _and_2 = false;
        } else {
            boolean _equals;
            String _qualifiedName = packge.getQualifiedName();
            _and_2 = _equals = _qualifiedName.equals("RTS");
        }
        _and_1 = !_and_2 ? false : (_isModelLibrary = packge.isModelLibrary());
        _and = !_and_1 ? false : (_equals_1 = Objects.equal((Object)normalizedPackageURI, (Object)normalizedRTSLibURI));
        _xblockexpression = _and;
        return _xblockexpression;
    }

    public static boolean isRTSModelLibrary(org.eclipse.papyrusrt.xtumlrt.common.Model model) {
        boolean _isSystemElement;
        boolean _and = false;
        boolean _and_1 = false;
        if (model == null) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name = model.getName();
            _and_1 = _equals = Objects.equal((Object)_name, (Object)"RTS");
        }
        _and = !_and_1 ? false : (_isSystemElement = XTUMLRTUtil.isSystemElement((CommonElement)model));
        return _and;
    }

    public static boolean isSystemElement(CommonElement element) {
        EList _annotations;
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        _and_1 = element == null || !(element instanceof NamedElement) ? false : (_tripleNotEquals = (_annotations = ((NamedElement)element).getAnnotations()) != null);
        if (!_and_1) {
            _and = false;
        } else {
            boolean _exists;
            EList _annotations_1 = ((NamedElement)element).getAnnotations();
            Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    EList _parameters_1;
                    boolean _isEmpty;
                    boolean _not;
                    EList _parameters;
                    boolean _tripleNotEquals;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    String _name = it.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)XTUMLRTUtil.RTS_LIBRARY_NAME);
                    _and_2 = !_equals ? false : (_tripleNotEquals = (_parameters = it.getParameters()) != null);
                    _and_1 = !_and_2 ? false : (_not = !(_isEmpty = (_parameters_1 = it.getParameters()).isEmpty()));
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _exists;
                        EList _parameters_2 = it.getParameters();
                        Functions.Function1<AnnotationParameter, Boolean> _function = new Functions.Function1<AnnotationParameter, Boolean>(){

                            public Boolean apply(AnnotationParameter it) {
                                String _value = it.getValue();
                                return Objects.equal((Object)_value, (Object)RTS_LIBRARY_URI_STR);
                            }
                        };
                        _and = _exists = IterableExtensions.exists((Iterable)_parameters_2, (Functions.Function1)_function);
                    }
                    return _and;
                }
            };
            _and = _exists = IterableExtensions.exists((Iterable)_annotations_1, (Functions.Function1)_function);
        }
        return _and;
    }

    public static boolean isSystemElement(Element element) {
        Model _model = element.getModel();
        return XTUMLRTUtil.isRTSModelLibrary((org.eclipse.uml2.uml.Package)_model);
    }

    public static Iterable<Capsule> getAllCapsules(EObject model) {
        if (model instanceof org.eclipse.papyrusrt.xtumlrt.common.Model) {
            return XTUMLRTUtil._getAllCapsules((org.eclipse.papyrusrt.xtumlrt.common.Model)model);
        }
        if (model instanceof Package) {
            return XTUMLRTUtil._getAllCapsules((Package)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    private static boolean redefines(RedefinableElement capsule, RedefinableElement part) {
        if (capsule instanceof Capsule && part instanceof CapsulePart) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (CapsulePart)part);
        }
        if (capsule instanceof Capsule && part instanceof Port) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (Port)part);
        }
        if (capsule instanceof Protocol && part instanceof Signal) {
            return XTUMLRTUtil._redefines((Protocol)capsule, (Signal)part);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(capsule, part).toString());
    }

    public static class NameComparator
    implements Comparator<NamedElement> {
        @Override
        public int compare(NamedElement o1, NamedElement o2) {
            boolean _equals = Objects.equal((Object)o1, null);
            if (_equals) {
                int _xifexpression = 0;
                boolean _equals_1 = Objects.equal((Object)o2, null);
                _xifexpression = _equals_1 ? 0 : -1;
                return _xifexpression;
            }
            boolean _equals_2 = Objects.equal((Object)o2, null);
            if (_equals_2) {
                return 1;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            boolean _equals_3 = Objects.equal((Object)name1, null);
            if (_equals_3) {
                int _xifexpression_1 = 0;
                boolean _equals_4 = Objects.equal((Object)name2, null);
                _xifexpression_1 = _equals_4 ? 0 : -1;
                return _xifexpression_1;
            }
            boolean _equals_5 = Objects.equal((Object)name2, null);
            if (_equals_5) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

