/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.IUMLRTElementTypes;

/**
 * Edit Helper Advices for RT connector
 */
public class RTConnectorEditHelperAdvice extends AbstractEditHelperAdvice {

	@Override
	protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
		return super.getBeforeCreateRelationshipCommand(request);
	}

	@Override
	protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
		return super.getBeforeCreateCommand(request);
	}

	@Override
	public boolean approveRequest(IEditCommandRequest request) {
		if (request instanceof ReorientRelationshipRequest) {
			EObject relationship = ((ReorientRelationshipRequest) request).getRelationship();
			if (ElementTypeUtils.matches(relationship, IUMLRTElementTypes.RT_CONNECTOR_ID)) {
				return checkNewTarget(((ReorientRelationshipRequest) request));
			}
			return super.approveRequest(request);
		}
		return super.approveRequest(request);
	}


	protected boolean checkNewTarget(ReorientRelationshipRequest reorientRelationshipRequest) {
		EObject newEnd = reorientRelationshipRequest.getNewRelationshipEnd();
		if (newEnd != null) {
			if (ElementTypeUtils.matches(newEnd, IUMLRTElementTypes.SERVICE_ACCESS_POINT_ID)) {
				return false; // cannot connect a connector to a SAP
			} else if (ElementTypeUtils.matches(newEnd, IUMLRTElementTypes.SERVICE_PROVISION_POINT_ID)) {
				return false;
			}
		}

		return true;
	}

	@Override
	protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
		return super.getBeforeReorientRelationshipCommand(request);
	}
}
