/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.IUMLRTElementTypes;
import org.eclipse.uml2.uml.Property;

/**
 * Utility class for capsule parts
 */
public class CapsulePartUtils {

	/**
	 * Returns <code>true</code> if the specified element is a CapsulePart (property typed by a capsule, and stereotyped by <<CapsulePart>>)
	 * 
	 * @param property
	 *            the property to check
	 * @return <code>true</code> if the specified element is a CapsulePart (property typed by a capsule, and stereotyped by <<CapsulePart>>)
	 */
	public static boolean isCapsulePart(Property property) {
		return ElementTypeUtils.matches(property, IUMLRTElementTypes.CAPSULE_PART_ID);
	}

}
