/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.sync;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.papyrus.infra.sync.EObjectEReferenceSyncFeature;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.uml.tools.utils.CustomUMLUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.Element;

public abstract class UMLSyncFeature<M extends Element, N extends Element>
extends EObjectEReferenceSyncFeature<M> {
    public UMLSyncFeature(SyncBucket<M, EObject, Notification> bucket, EReference reference, EReference ... more) {
        super(bucket, reference, more);
    }

    protected abstract Class<? extends SyncRegistry<N, EObject, Notification>> getNestedRegistryType();

    protected SyncRegistry<N, EObject, Notification> getNestedRegistry() {
        return this.getSyncRegistry(this.getNestedRegistryType());
    }

    protected Command createDeleteCommand(final EObject object) {
        return new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                if (object instanceof Element) {
                    ((Element)object).destroy();
                } else {
                    CustomUMLUtil.destroy((EObject)object);
                }
            }
        };
    }

    protected boolean match(EObject sourceModel, EObject targetModel) {
        boolean result = false;
        SyncRegistry<N, EObject, Notification> nestedRegistry = this.getNestedRegistry();
        result = nestedRegistry.getModelType().isInstance(sourceModel) && nestedRegistry.synchronizes((Object)targetModel, (Object)((Element)nestedRegistry.getModelType().cast(sourceModel)));
        result = result || CapsuleUtils.redefines((EObject)targetModel, (EObject)sourceModel);
        return result;
    }
}

