/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class PackageEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlEnumerationLiteralType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.EnumerationLiteral");
            if (umlEnumerationLiteralType != null) {
                if (ElementTypeUtils.isTypeCompatible(type, umlEnumerationLiteralType)) {
                    return false;
                }
            } else {
                Activator.log.debug("Impossible to find element type for UML EnumerationLiteral");
            }
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        Object result = null;
        CompositeCommand compositeMoveCommand = new CompositeCommand("Composite Move Command");
        Map elementsToMove = request.getElementsToMove();
        if (!elementsToMove.isEmpty()) {
            for (Object elementToMove : elementsToMove.keySet()) {
                Element protocol;
                Package protocolContainer;
                if (!(elementToMove instanceof Collaboration) || (protocolContainer = (protocol = (Element)elementToMove).getNearestPackage()) == null) continue;
                MoveElementsCommand command = ProtocolContainerUtils.createMoveProtocolContainerCommand(request, (EObject)protocolContainer);
                compositeMoveCommand.add((IUndoableOperation)command);
                request.setParameter("IEditCommandRequest.replaceDefaultCommand", (Object)true);
            }
        }
        result = compositeMoveCommand.isEmpty() ? super.getAfterMoveCommand(request) : compositeMoveCommand;
        return result;
    }
}

