/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.elementtypesconfigurations.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.AndInvariantRuleConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.CompositeInvariantRuleConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.InvariantRuleConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.InvariantTypeConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.NotInvariantRuleConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypeconfiguration.OrInvariantRuleConfiguration;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypes.invarianttypeconfiguration.IInvariantRule;
import org.eclipse.papyrus.infra.elementtypesconfigurations.invarianttypes.invarianttypeconfiguration.InvariantRuleConfigurationTypeRegistry;
import org.eclipse.papyrus.uml.tools.elementtypesconfigurations.invariantstereotyperuleconfiguration.InvariantStereotypeRuleConfiguration;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLRTElementOwnerAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        List<ConfiguredHintedSpecializationElementType> types = this.getInvariantTypes(request);
        for (ConfiguredHintedSpecializationElementType configuredHintedSpecializationElementType : types) {
            if (this.approveRequest(configuredHintedSpecializationElementType, request)) continue;
            return false;
        }
        return true;
    }

    protected List<ConfiguredHintedSpecializationElementType> getInvariantTypes(IEditCommandRequest request) {
        ArrayList<ConfiguredHintedSpecializationElementType> result;
        block11: {
            block12: {
                block10: {
                    result = new ArrayList<ConfiguredHintedSpecializationElementType>();
                    if (!(request instanceof CreateElementRequest)) break block10;
                    IElementType typeToCreate = ((CreateElementRequest)request).getElementType();
                    List<ConfiguredHintedSpecializationElementType> superConfiguredTypes = this.getAllInvariantTypes(typeToCreate);
                    result.addAll(superConfiguredTypes);
                    break block11;
                }
                if (!(request instanceof SetRequest)) break block12;
                EStructuralFeature feature = ((SetRequest)request).getFeature();
                if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) break block11;
                Object value = ((SetRequest)request).getValue();
                ArrayList<Object> values = new ArrayList<Object>();
                if (value instanceof EObject) {
                    values.add(value);
                } else if (value instanceof List) {
                    values.addAll((List)value);
                }
                for (Object e : values) {
                    IElementType[] types;
                    if (!(e instanceof EObject)) continue;
                    IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)e, request.getClientContext());
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IElementType type = iElementTypeArray[n2];
                        if (type instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)type).getConfiguration() instanceof InvariantTypeConfiguration) {
                            result.add((ConfiguredHintedSpecializationElementType)type);
                            List<ConfiguredHintedSpecializationElementType> superConfiguredTypes = this.getAllSuperConfiguredTypes((ConfiguredHintedSpecializationElementType)type);
                            result.addAll(superConfiguredTypes);
                        }
                        ++n2;
                    }
                }
                break block11;
            }
            if (request instanceof MoveRequest) {
                Map objectsToMove = ((MoveRequest)request).getElementsToMove();
                for (Map.Entry movedElement : objectsToMove.entrySet()) {
                    IElementType[] iElementTypeArray;
                    IElementType[] iElementTypeArray2 = iElementTypeArray = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)movedElement.getKey(), request.getClientContext());
                    int n = iElementTypeArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IElementType type = iElementTypeArray2[n3];
                        if (type instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)type).getConfiguration() instanceof InvariantTypeConfiguration) {
                            result.add((ConfiguredHintedSpecializationElementType)type);
                            List<ConfiguredHintedSpecializationElementType> superConfiguredTypes = this.getAllSuperConfiguredTypes((ConfiguredHintedSpecializationElementType)type);
                            result.addAll(superConfiguredTypes);
                        }
                        ++n3;
                    }
                }
            }
        }
        return result;
    }

    protected List<ConfiguredHintedSpecializationElementType> getAllInvariantTypes(IElementType type) {
        IElementType[] superTypes;
        ArrayList<ConfiguredHintedSpecializationElementType> result = new ArrayList<ConfiguredHintedSpecializationElementType>();
        if (!(type instanceof ConfiguredHintedSpecializationElementType)) {
            return result;
        }
        if (((ConfiguredHintedSpecializationElementType)type).getConfiguration() instanceof InvariantTypeConfiguration) {
            result.add((ConfiguredHintedSpecializationElementType)type);
        }
        if ((superTypes = type.getAllSuperTypes()).length == 0) {
            return result;
        }
        int i = superTypes.length - 1;
        while (i >= 0) {
            if (superTypes[i] instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)superTypes[i]).getConfiguration() instanceof InvariantTypeConfiguration) {
                result.add((ConfiguredHintedSpecializationElementType)superTypes[i]);
            }
            --i;
        }
        return result;
    }

    protected List<ConfiguredHintedSpecializationElementType> getAllSuperConfiguredTypes(ConfiguredHintedSpecializationElementType type) {
        IElementType[] superTypes = type.getAllSuperTypes();
        if (superTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConfiguredHintedSpecializationElementType> superExtendedTypes = new ArrayList<ConfiguredHintedSpecializationElementType>();
        int i = superTypes.length - 1;
        while (i >= 0) {
            if (superTypes[i] instanceof ConfiguredHintedSpecializationElementType && ((ConfiguredHintedSpecializationElementType)superTypes[i]).getConfiguration() instanceof InvariantTypeConfiguration) {
                superExtendedTypes.add((ConfiguredHintedSpecializationElementType)superTypes[i]);
            }
            --i;
        }
        return superExtendedTypes;
    }

    protected boolean processCompositeRule(CompositeInvariantRuleConfiguration compositeRule, IEditCommandRequest request) {
        Iterator iterator = compositeRule.getComposedRules().iterator();
        InvariantRuleConfiguration nextComposedRuleConfiguration = (InvariantRuleConfiguration)iterator.next();
        boolean result = this.processInvariantRule(nextComposedRuleConfiguration, request);
        while (iterator.hasNext()) {
            nextComposedRuleConfiguration = (InvariantRuleConfiguration)iterator.next();
            boolean resultNextComposedRuleConfiguration = this.processInvariantRule(nextComposedRuleConfiguration, request);
            if (compositeRule instanceof OrInvariantRuleConfiguration) {
                if (result || !resultNextComposedRuleConfiguration) continue;
                result = true;
                continue;
            }
            if (!(compositeRule instanceof AndInvariantRuleConfiguration) || !result || resultNextComposedRuleConfiguration) continue;
            result = false;
        }
        return result;
    }

    protected boolean processInvariantRule(InvariantRuleConfiguration invariantRuleConfiguration, IEditCommandRequest request) {
        if (invariantRuleConfiguration instanceof CompositeInvariantRuleConfiguration) {
            return this.processCompositeRule((CompositeInvariantRuleConfiguration)invariantRuleConfiguration, request);
        }
        if (invariantRuleConfiguration instanceof NotInvariantRuleConfiguration) {
            InvariantRuleConfiguration composedRule = ((NotInvariantRuleConfiguration)invariantRuleConfiguration).getComposedRule();
            return !this.processInvariantRule(composedRule, request);
        }
        if (invariantRuleConfiguration instanceof InvariantStereotypeRuleConfiguration) {
            return this.processStereotypeInvariantRuleConfiguration((InvariantStereotypeRuleConfiguration)invariantRuleConfiguration, request);
        }
        IInvariantRule rule = InvariantRuleConfigurationTypeRegistry.getInstance().getInvariantRule(invariantRuleConfiguration);
        return rule.approveRequest(request);
    }

    protected boolean processStereotypeInvariantRuleConfiguration(InvariantStereotypeRuleConfiguration ruleConfiguration, IEditCommandRequest req) {
        if (req instanceof CreateElementRequest) {
            CreateElementRequest request = (CreateElementRequest)req;
            String requiredProfileName = ruleConfiguration.getRequiredProfile();
            if (requiredProfileName != null) {
                EObject container = request.getContainer();
                if (!(container instanceof Element)) {
                    return false;
                }
                Package nearestPackage = ((Element)container).getNearestPackage();
                if (nearestPackage == null) {
                    return false;
                }
                Profile appliedProfile = nearestPackage.getAppliedProfile(requiredProfileName, true);
                return appliedProfile != null;
            }
            return true;
        }
        IInvariantRule rule = InvariantRuleConfigurationTypeRegistry.getInstance().getInvariantRule((InvariantRuleConfiguration)ruleConfiguration);
        return rule.approveRequest(req);
    }

    protected boolean approveRequest(ConfiguredHintedSpecializationElementType elementType, IEditCommandRequest request) {
        ElementTypeConfiguration configuration = elementType.getConfiguration();
        if (configuration instanceof InvariantTypeConfiguration) {
            InvariantRuleConfiguration invariantRuleConfiguration = ((InvariantTypeConfiguration)configuration).getInvariantRuleConfiguration();
            return this.processInvariantRule(invariantRuleConfiguration, request);
        }
        Activator.log.warn("Expected InvariantRuleConfiguration as configuration type for : " + elementType);
        return true;
    }
}

