/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeNameEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.PortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies.RTCustomDiagramDragDropEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies.RTSideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;


/**
 * The Class RTClassCompositeEditPart defines how an affixed Child node can be added in the Real Time Context.
 * A port can be added inside the Bounds instead of exclusively on the boundaries;
 */
public class RTClassCompositeEditPart extends ClassCompositeEditPart {

	/**
	 * Instantiates a new RT class composite edit part.
	 *
	 * @param view
	 *            the view
	 */
	public RTClassCompositeEditPart(View view) {
		super(view);

	}

	/**
	 * Add the specific EditPolicies to DND and to Create an RT port
	 * 
	 * @see org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeEditPart#createDefaultEditPolicies()
	 *
	 */
	@Override
	protected void createDefaultEditPolicies() {

		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.CREATION_ROLE, new RTSideAffixedNodesCreationEditPolicy());
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE, new RTCustomDiagramDragDropEditPolicy());
	}

	/**
	 * Redefine the way the Affixed Child note is added to the EditPart by specifying the Port Position Locator as {@link RTPortPositionLocator}.
	 * 
	 * @see org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeEditPart#addFixedChild(org.eclipse.gef.EditPart)
	 *
	 * @param childEditPart
	 * @return
	 */
	@Override
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof ClassCompositeNameEditPart) {
			((ClassCompositeNameEditPart) childEditPart).setLabel(getPrimaryShape().getNameLabel());
			return true;
		}
		if (childEditPart instanceof ClassCompositeCompartmentEditPart) {
			IFigure pane = getPrimaryShape().getCompositeCompartmentFigure();
			setupContentPane(pane); // FIXME each compartment should handle his content pane in his own way
			pane.add(((ClassCompositeCompartmentEditPart) childEditPart).getFigure());
			return true;
		}
		// Papyrus Gencode :Affixed Port locator
		if (childEditPart instanceof PortEditPart) {
			IBorderItemLocator locator = new RTPortPositionLocator(((PortEditPart) childEditPart).getUMLElement(), getMainFigure(), PositionConstants.NONE);
			getBorderedFigure().getBorderItemContainer().add(((PortEditPart) childEditPart).getFigure(), locator);
			return true;
		}
		return false;
	}

}
