/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.providers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.ClassCompositeEditPart;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.RTClassCompositeEditPart;
import org.eclipse.uml2.uml.Classifier;


/**
 * The Class RTEditPartProvider provide the editParts for the Real Time specification.
 * This is applied for the Composite Structure Diagram
 */
public class RTEditPartProvider extends AbstractEditPartProvider {

	/** The provides only provides for this diagram type. */
	protected String diagramType = org.eclipse.papyrus.uml.diagram.composite.edit.parts.CompositeStructureDiagramEditPart.MODEL_ID;

	/** Map containing node view types supported by this provider. */
	protected Map<String, Class<?>> nodeMap = new HashMap<String, Class<?>>();

	/** Map containing edge view types supported by this provider. */
	protected Map<String, Class<?>> edgeMap = new HashMap<String, Class<?>>();

	/**
	 * Default constructor.
	 */
	public RTEditPartProvider() {
		super();

		// Nodes
		nodeMap.put(Integer.toString(ClassCompositeEditPart.VISUAL_ID), RTClassCompositeEditPart.class);
	}

	/**
	 * Provides.
	 *
	 * @param operation
	 *            the operation
	 * @return true, if successful
	 * @see org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider#provides(org.eclipse.gmf.runtime.common.core.service.IOperation)
	 */
	@Override
	public boolean provides(IOperation operation) {

		boolean provide = false;
		String currentDiagramType;
		EObject referenceElement = ((IEditPartOperation) operation).getView().getElement();
		if ((operation instanceof CreateGraphicEditPartOperation) && (referenceElement instanceof Classifier) && (CapsuleUtils.isCapsule((Classifier) referenceElement))) {

			currentDiagramType = ((IEditPartOperation) operation).getView().getDiagram().getType();

			if ((diagramType == null) || (!diagramType.equals(currentDiagramType))) {
				provide = false;
			} else {
				provide = super.provides(operation);
			}


		}

		return provide;

	}

	/**
	 * Gets the node edit part class.
	 *
	 * @param view
	 *            the view
	 * @return the node edit part class
	 * @see org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider#getNodeEditPartClass(org.eclipse.gmf.runtime.notation.View)
	 */
	@Override
	protected Class getNodeEditPartClass(View view) {

		return nodeMap.get(view.getType());
	}

}
