/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Ansgar Radermacher (CEA LIST) ansgar.radermacher@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.ui.editors;

import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/**
 * An editor for (technically) multiple references that typically have a single value.
 * In the moment, the only modification is to show a list of values without a minimum height.
 */
public class SingleMultiReferenceEditor extends MultipleReferenceEditor {

	public SingleMultiReferenceEditor(Composite parent, int style) {
		super(parent, style);
		
		// update minimum height
		GridData treeData = new GridData(SWT.FILL, SWT.FILL, true, true);
		treeData.horizontalSpan = 2;
		treeData.minimumHeight = -1;
		treeData.heightHint = 16;
		tree.setLayoutData(treeData);
	}
}
