package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.ExtendedMultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.helper.UMLDatabindingHelper;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsulePartExtendedObservableValue extends ExtendedMultiplicityObservableValue {

	/**
	 * The number of ObservableValue in the ObservableList.
	 */
	private static final int NUMBER_OBSERVABLE_VALUES = 3;

	private EditingDomain domain;
	private ArrayList<IObservableValue> observableValues;

	public CapsulePartExtendedObservableValue(final EObject eObject, final EditingDomain domain) {
		super(eObject, domain);
		this.domain = domain;
		this.observableValues = new ArrayList<IObservableValue>(NUMBER_OBSERVABLE_VALUES);
		if (null != eObject) {

			observableValues.add(new CapsulePartMultiplicityObservableValue(eObject, domain));

			// Get the lower and upper values features
			final EStructuralFeature lowerValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
			final EStructuralFeature upperValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();

			// Add the ObservableValues
			observableValues.add(UMLDatabindingHelper.getObservableValue(eObject, lowerValueFeature, domain));
			observableValues.add(UMLDatabindingHelper.getObservableValue(eObject, upperValueFeature, domain));
		}
	}

	public CapsulePartExtendedObservableValue(EditingDomain domain) {
		super(domain);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable#aggregate(org.eclipse.core.databinding.observable.IObservable)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public AggregatedObservable aggregate(final IObservable observable) {
		if (observable instanceof IObservableValue) {
			final Object value = ((IObservableValue) observable).getValue();
			if (value instanceof List<?> && NUMBER_OBSERVABLE_VALUES == ((List<?>) value).size() && isAllIObservableValueType((List<?>) value)) {
				final ExtendedMultiplicityObservableValue result = new CapsulePartExtendedObservableValue(domain);

				int count = 0;
				while (count < NUMBER_OBSERVABLE_VALUES) {
					final IObservableValue existingMultiplicityValues = observableValues.get(count);
					final IObservableValue multiplicityValueToAggregate = ((List<IObservableValue>) value).get(count);
					if (existingMultiplicityValues instanceof AggregatedObservable) {
						final IObservableValue aggregatedObservable = (IObservableValue) ((AggregatedObservable) existingMultiplicityValues).aggregate(multiplicityValueToAggregate);
						result.getObservableValues().add((IObservableValue) DelegatingObservable.wrap(aggregatedObservable));
					}
					count++;
				}

				return result;
			}
		}
		return new AggregatedPapyrusObservableValue(domain, this, observable);
	}

	/**
	 * Get if all the elements of the list are observable values.
	 * 
	 * @param values
	 *            The values list.
	 * @return <code>true</code> if all the elements are observable values, <code>false</code> otherwise.
	 */
	private boolean isAllIObservableValueType(final List<?> values) {
		boolean result = true;
		final Iterator<?> value = values.iterator();

		while (result && value.hasNext()) {
			if (!(value.next() instanceof IObservableValue)) {
				result = false;
			}
		}

		return result;
	}

}
