/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.ExtendedMultiplicityObservableValue;
import org.eclipse.papyrus.uml.tools.helper.UMLDatabindingHelper;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartMultiplicityObservableValue;
import org.eclipse.uml2.uml.UMLPackage;

public class CapsulePartExtendedObservableValue
extends ExtendedMultiplicityObservableValue {
    private static final int NUMBER_OBSERVABLE_VALUES = 3;
    private EditingDomain domain;
    private ArrayList<IObservableValue> observableValues;

    public CapsulePartExtendedObservableValue(EObject eObject, EditingDomain domain) {
        super(eObject, domain);
        this.domain = domain;
        this.observableValues = new ArrayList(3);
        if (eObject != null) {
            this.observableValues.add((IObservableValue)new CapsulePartMultiplicityObservableValue(eObject, domain));
            EReference lowerValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
            EReference upperValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
            this.observableValues.add(UMLDatabindingHelper.getObservableValue((EObject)eObject, (EStructuralFeature)lowerValueFeature, (EditingDomain)domain));
            this.observableValues.add(UMLDatabindingHelper.getObservableValue((EObject)eObject, (EStructuralFeature)upperValueFeature, (EditingDomain)domain));
        }
    }

    public CapsulePartExtendedObservableValue(EditingDomain domain) {
        super(domain);
    }

    public AggregatedObservable aggregate(IObservable observable) {
        Object value;
        if (observable instanceof IObservableValue && (value = ((IObservableValue)observable).getValue()) instanceof List && 3 == ((List)value).size() && this.isAllIObservableValueType((List)value)) {
            CapsulePartExtendedObservableValue result = new CapsulePartExtendedObservableValue(this.domain);
            int count = 0;
            while (count < 3) {
                IObservableValue existingMultiplicityValues = this.observableValues.get(count);
                IObservableValue multiplicityValueToAggregate = (IObservableValue)((List)value).get(count);
                if (existingMultiplicityValues instanceof AggregatedObservable) {
                    IObservableValue aggregatedObservable = (IObservableValue)((AggregatedObservable)existingMultiplicityValues).aggregate((IObservable)multiplicityValueToAggregate);
                    result.getObservableValues().add((IObservableValue)DelegatingObservable.wrap((IObservable)aggregatedObservable));
                }
                ++count;
            }
            return result;
        }
        return new AggregatedPapyrusObservableValue(this.domain, new IObservable[]{this, observable});
    }

    private boolean isAllIObservableValueType(List<?> values) {
        boolean result = true;
        Iterator<?> value = values.iterator();
        while (result && value.hasNext()) {
            if (value.next() instanceof IObservableValue) continue;
            result = false;
        }
        return result;
    }
}

