/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.widgets.ReferenceDialog;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.util.UMLUtil;

public class EventSelectionDialog
extends ReferenceDialog {
    protected Port port;

    public EventSelectionDialog(Composite parent, int style) {
        super(parent, style);
    }

    protected void doBinding() {
        IObservableValue inputObservableValue;
        this.editor.setLabelProvider(this.input.getLabelProvider(this.propertyPath));
        this.editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        this.editor.setMandatory(this.input.isMandatory(this.propertyPath));
        this.updatePort();
        Package protocolContainer = null;
        if (this.port != null && this.port.getType() != null) {
            protocolContainer = this.port.getType().getNearestPackage();
        }
        this.editor.setContentProvider((IStaticContentProvider)new EventContentProvider(protocolContainer));
        if (this.valueEditor != null && (inputObservableValue = this.getInputObservableValue()) != null) {
            this.valueEditor.setStrategies();
            IValidator modelVal = this.getValidator();
            if (modelVal != null) {
                this.valueEditor.setModelValidator(modelVal);
            }
            this.valueEditor.setModelObservable(inputObservableValue);
        }
    }

    protected void updatePort() {
        Trigger trigger;
        ModelElement portElement = this.input.getModelElement(this.propertyPath);
        EObject triggerEObj = ((UMLModelElement)portElement).getSource();
        this.port = null;
        if (triggerEObj instanceof Trigger && (trigger = (Trigger)triggerEObj).getPorts().size() > 0) {
            this.port = (Port)trigger.getPorts().get(0);
        }
    }

    protected class EventContentProvider
    implements IStaticContentProvider {
        Package protocolContainer;

        public EventContentProvider(Package protocolContainer) {
            this.protocolContainer = protocolContainer;
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            EventSelectionDialog.this.updatePort();
            this.protocolContainer = EventSelectionDialog.this.port != null && EventSelectionDialog.this.port.getType() != null ? EventSelectionDialog.this.port.getType().getNearestPackage() : null;
        }

        public Object[] getElements() {
            ArrayList<CallEvent> events = new ArrayList<CallEvent>();
            if (this.protocolContainer != null) {
                for (PackageableElement pe : this.protocolContainer.getPackagedElements()) {
                    CallEvent event;
                    Interface intf;
                    RTMessageSet rtMessageSet;
                    RTMessageKind kind;
                    if (!(pe instanceof CallEvent) || (kind = (rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)(intf = (event = (CallEvent)pe).getOperation().getInterface()), RTMessageSet.class)).getRtMsgKind()) != RTMessageKind.IN_OUT && (kind != RTMessageKind.IN || EventSelectionDialog.this.port.isConjugated()) && (kind != RTMessageKind.OUT || !EventSelectionDialog.this.port.isConjugated())) continue;
                    events.add(event);
                }
            }
            return events.toArray();
        }
    }
}

