/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortRTKindObservableValue
extends PapyrusObservableValue
implements IObserving {
    private Port port;
    private EObject stereotypeApplication;
    private boolean service;
    private boolean wired;
    private boolean behavior;
    private boolean publish;
    private boolean conjugated;
    private boolean notification;

    public PortRTKindObservableValue(EObject RTPortApplication, TransactionalEditingDomain domain) {
        super((EObject)UMLUtil.getBaseElement((EObject)RTPortApplication), UMLUtil.getBaseElement((EObject)RTPortApplication).eContainingFeature(), (EditingDomain)domain);
        this.port = (Port)UMLUtil.getBaseElement((EObject)RTPortApplication);
        if (UMLUtil.getBaseElement((EObject)RTPortApplication) instanceof Port) {
            this.port = (Port)UMLUtil.getBaseElement((EObject)RTPortApplication);
            this.stereotypeApplication = RTPortApplication;
            this.stereotypeApplication.eAdapters().add((Object)this.getListener());
            this.port.eAdapters().add((Object)this.getListener());
            this.setUMLPropertiesValue();
            this.setUMLRTPropertiesValue();
        }
    }

    protected AdapterImpl getListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                EList realTimeFeatureList = PortRTKindObservableValue.this.stereotypeApplication.eClass().getEStructuralFeatures();
                EList umlFeatureList = PortRTKindObservableValue.this.port.eClass().getEStructuralFeatures();
                if (notifier == PortRTKindObservableValue.this.stereotypeApplication && type == 1) {
                    if (realTimeFeatureList.contains(feature)) {
                        this.fireDiff(notification);
                    }
                } else if (notifier == PortRTKindObservableValue.this.port && type == 1 && umlFeatureList.contains(feature)) {
                    this.fireDiff(notification);
                }
            }

            private void fireDiff(Notification notification) {
                final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                PortRTKindObservableValue.this.getRealm().exec(new Runnable(){

                    @Override
                    public void run() {
                        PortRTKindObservableValue.this.fireValueChange(diff);
                    }
                });
            }
        };
    }

    private void setUMLRTPropertiesValue() {
        this.wired = RTPortUtils.isWired((Port)this.port);
        this.notification = RTPortUtils.isNotification((Port)this.port);
        this.publish = RTPortUtils.isPublish((Port)this.port);
    }

    private void setUMLPropertiesValue() {
        this.service = RTPortUtils.isService((Port)this.port);
        this.behavior = RTPortUtils.isBehavior((Port)this.port);
        this.conjugated = RTPortUtils.isConjugated((Port)this.port);
    }

    public Object getValueType() {
        return RTPortKindEnum.class;
    }

    public Object getObserved() {
        return this.port;
    }

    protected Object doGetValue() {
        RTPortKindEnum kind = RTPortKindEnum.RELAY;
        this.setUMLPropertiesValue();
        this.setUMLRTPropertiesValue();
        if (this.service && this.wired && this.behavior) {
            kind = RTPortKindEnum.EXTERNAL;
        } else if (this.service && this.behavior && !this.wired) {
            kind = RTPortKindEnum.SPP;
        } else if (this.wired && this.behavior && !this.service) {
            kind = RTPortKindEnum.INTERNAL;
        } else if (this.service && this.wired && !this.behavior) {
            kind = RTPortKindEnum.RELAY;
        } else if (this.behavior && !this.wired && !this.service) {
            kind = RTPortKindEnum.SAP;
        }
        return kind;
    }

    public Command getCommand(Object value) {
        Command command = null;
        if (value instanceof RTPortKindEnum) {
            switch ((RTPortKindEnum)value) {
                case EXTERNAL: {
                    command = this.getCommandForRTPort(true, true, true);
                    break;
                }
                case INTERNAL: {
                    command = this.getCommandForRTPort(true, false, true);
                    break;
                }
                case RELAY: {
                    command = this.getCommandForRTPort(false, true, true);
                    break;
                }
                case SAP: {
                    command = this.getCommandForRTPort(true, false, false);
                    break;
                }
                case SPP: {
                    command = this.getCommandForRTPort(true, true, false);
                    break;
                }
                default: {
                    command = this.getCommandForRTPort(false, true, true);
                }
            }
        }
        return command;
    }

    protected Command getCommandForRTPort(boolean behavior, boolean service, boolean wired) {
        CompoundCommand command = new CompoundCommand();
        command.append(this.getSetBehaviorCommand(behavior));
        command.append(this.getSetServiceCommand(service));
        command.append(this.getSetWiredCommand(wired));
        return command;
    }

    protected Command getSetPublishCommand(boolean publish) {
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)this.stereotypeApplication);
        SetRequest request = new SetRequest(this.stereotypeApplication, this.stereotypeApplication.eClass().getEStructuralFeature("isPublish"), (Object)publish);
        ICommand gmfCommand = serviceEdit.getEditCommand((IEditCommandRequest)request);
        Command cmd = GMFtoEMFCommandWrapper.wrap((ICommand)gmfCommand);
        return cmd;
    }

    protected Command getSetWiredCommand(boolean wired) {
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)this.stereotypeApplication);
        SetRequest request = new SetRequest(this.stereotypeApplication, this.stereotypeApplication.eClass().getEStructuralFeature("isWired"), (Object)wired);
        ICommand gmfCommand = serviceEdit.getEditCommand((IEditCommandRequest)request);
        Command cmd = GMFtoEMFCommandWrapper.wrap((ICommand)gmfCommand);
        return cmd;
    }

    protected Command getSetServiceCommand(boolean service) {
        Command cmd = null;
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)this.port);
        SetRequest request = new SetRequest((EObject)this.port, this.port.eClass().getEStructuralFeature("isService"), (Object)service);
        ICommand gmfCommand = serviceEdit.getEditCommand((IEditCommandRequest)request);
        cmd = GMFtoEMFCommandWrapper.wrap((ICommand)gmfCommand);
        return cmd;
    }

    protected Command getSetBehaviorCommand(boolean behavior) {
        Command cmd = null;
        IElementEditService serviceEdit = ElementEditServiceUtils.getCommandProvider((Object)this.port);
        SetRequest request = new SetRequest((EObject)this.port, this.port.eClass().getEStructuralFeature("isBehavior"), (Object)behavior);
        ICommand gmfCommand = serviceEdit.getEditCommand((IEditCommandRequest)request);
        cmd = GMFtoEMFCommandWrapper.wrap((ICommand)gmfCommand);
        return cmd;
    }
}

