/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Mickael ADAM (ALL4TEC) mickael.adam@all4tec.net - add RTPORT_KIND_REQUEST_PARAMETER 
 * Celine Janssens (ALL4TEC) celine.janssens@all4tec.net  - Bug 472884
 *   
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * Utility class on {@link Operation} that are RTMessage.
 */
public class RTPortUtils {

	/** The Constant RTPORT_KIND_REQUEST_PARAMETER. Used as key on creation request to define which kind of RTPort we want to create. */
	public static final String RTPORT_KIND_REQUEST_PARAMETER = "RTPORT_KIND";

	/**
	 * Checks if is a RT port.
	 *
	 * @param eObject
	 *            the e object
	 * @return true, if is a RT port
	 */
	public static boolean isRTPort(EObject eObject) {
		if (eObject instanceof Port) {
			// get Owner of the operation, and check if this is a messageSET
			Port port = (Port) eObject;
			return (null != getStereotypeApplication(port));

		}
		return false;
	}

	public boolean isConnected(Port port) {
		// TODO To Implement
		return true;
	}

	public static RTPort getStereotypeApplication(Port port) {
		return UMLUtil.getStereotypeApplication(port, RTPort.class);

	}


	public static boolean isWired(Port port) {

		return getStereotypeApplication(port) == null ? false : (Boolean) getStereotypeApplication(port).isWired();
	}

	public static boolean isPublish(Port port) {
		return getStereotypeApplication(port) == null ? false : (Boolean) getStereotypeApplication(port).isPublish();
	}

	public static boolean isNotification(Port port) {
		return getStereotypeApplication(port) == null ? false : (Boolean) getStereotypeApplication(port).isNotification();
	}

	public static boolean isBehavior(Port port) {
		return port.isBehavior();
	}

	public static boolean isService(Port port) {
		return port.isService();
	}

	public static boolean isConjugated(Port port) {
		return port.isConjugated();
	}

	/**
	 * Gets the kind of the RT Port.
	 *
	 * @param port
	 *            the port
	 * @return the kind
	 */
	public static RTPortKindEnum getKind(Port port) {
		RTPortKindEnum kind = null;
		if (isRTPort(port)) {
			if (isService(port) && isWired(port) && isBehavior(port) && !isPublish(port)) {
				kind = RTPortKindEnum.EXTERNAL;
			} else if (isService(port) && isBehavior(port) && isPublish(port) && !isWired(port)) {
				kind = RTPortKindEnum.SPP;
			} else if (isWired(port) && isBehavior(port) && !isService(port) && !isPublish(port)) {
				kind = RTPortKindEnum.INTERNAL;
			} else if (isService(port) && isWired(port) && !isBehavior(port) && !isPublish(port)) {
				kind = RTPortKindEnum.RELAY;
			} else if (isBehavior(port) && !isWired(port) && !isPublish(port) && !isService(port)) {
				kind = RTPortKindEnum.SAP;
			}
		}

		return kind;
	}


}
