/*****************************************************************************
 * Copyright (c) 2014 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  CEA LIST - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.papyrusrt.umlrt.profile.util.UMLRTResource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/**
 * Util methods for UML-RT profile
 */
public class UMLRTProfileUtils {

	public static boolean isUMLRTProfileApplied(Element element) {
		Package package_ = element.getNearestPackage();
		if (package_ == null) {
			return false;
		}

		for (Profile profile : package_.getAllAppliedProfiles()) {
			if (UMLRTResource.PROFILE_URI.equals(profile.getURI())) {
				return true;
			}
		}
		return false;
	}
}
