/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrusrt.umlrt.core.Activator;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class ProtocolUtils {
    public static Package getProtocolContainer(Collaboration protocol) {
        return protocol.getNearestPackage();
    }

    public static Boolean isProtocol(EObject context) {
        return ElementTypeUtils.matches(context, "org.eclipse.papyrusrt.umlrt.core.Protocol");
    }

    public static List<Operation> getRTMessages(Collaboration protocol, RTMessageKind direction, boolean showInherited) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(protocol);
        if (protocolContainer == null) {
            Activator.log.error("Impossible to get the root protocol container", null);
            return Collections.emptyList();
        }
        return ProtocolContainerUtils.getRTMessages(protocolContainer, direction, showInherited);
    }

    public static Interface getMessageSet(Collaboration editContext, RTMessageKind direction) {
        Package protocolContainer = ProtocolUtils.getProtocolContainer(editContext);
        if (protocolContainer != null) {
            return ProtocolContainerUtils.getMessageSet(protocolContainer, direction);
        }
        return null;
    }

    public static Interface getMessageSetIn(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN);
    }

    public static Interface getMessageSetOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.OUT);
    }

    public static Interface getMessageSetInOut(Collaboration editContext) {
        return ProtocolUtils.getMessageSet(editContext, RTMessageKind.IN_OUT);
    }

    public static EList<Package> getAllProtocols(Package protocol) {
        BasicEList allProtocols = new BasicEList();
        allProtocols.add((Object)protocol);
        Package baseProtocol = ProtocolUtils.getBaseProtocol((Element)protocol);
        if (baseProtocol != null && protocol != baseProtocol) {
            allProtocols.add((Object)baseProtocol);
        }
        return allProtocols;
    }

    public static boolean isCommonProtocol(EList<Package> protocolSet, Package protocolCandidate) {
        for (Package protocol : protocolSet) {
            if (ProtocolUtils.getAllProtocols(protocol).contains((Object)protocolCandidate)) continue;
            return false;
        }
        return true;
    }

    public static Package getBaseProtocol(Element anElement) {
        if (anElement != null) {
            PackageableElement baseProtocolCandidate;
            NamedElement protocols;
            Package root = PackageUtil.getRootPackage((Element)anElement);
            if (anElement != null && root instanceof Package && (protocols = root.getMember("Protocols")) instanceof Package && (baseProtocolCandidate = ((Package)protocols).getPackagedElement("UMLRTBaseCommProtocol")) instanceof Package) {
                return (Package)baseProtocolCandidate;
            }
        }
        return null;
    }
}

