/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RTPortUtils {
    public static final String RTPORT_KIND_REQUEST_PARAMETER = "RTPORT_KIND";

    public static boolean isRTPort(EObject eObject) {
        if (eObject instanceof Port) {
            Port port = (Port)eObject;
            return RTPortUtils.getStereotypeApplication(port) != null;
        }
        return false;
    }

    public boolean isConnected(Port port) {
        return true;
    }

    public static RTPort getStereotypeApplication(Port port) {
        return (RTPort)UMLUtil.getStereotypeApplication((Element)port, RTPort.class);
    }

    public static boolean isWired(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isWired());
    }

    public static boolean isPublish(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isPublish());
    }

    public static boolean isNotification(Port port) {
        return RTPortUtils.getStereotypeApplication(port) == null ? false : Boolean.valueOf(RTPortUtils.getStereotypeApplication(port).isNotification());
    }

    public static boolean isBehavior(Port port) {
        return port.isBehavior();
    }

    public static boolean isService(Port port) {
        return port.isService();
    }

    public static boolean isConjugated(Port port) {
        return port.isConjugated();
    }

    public static RTPortKindEnum getKind(Port port) {
        RTPortKindEnum kind = null;
        if (RTPortUtils.isRTPort((EObject)port)) {
            if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.EXTERNAL;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isBehavior(port) && RTPortUtils.isPublish(port) && !RTPortUtils.isWired(port)) {
                kind = RTPortKindEnum.SPP;
            } else if (RTPortUtils.isWired(port) && RTPortUtils.isBehavior(port) && !RTPortUtils.isService(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.INTERNAL;
            } else if (RTPortUtils.isService(port) && RTPortUtils.isWired(port) && !RTPortUtils.isBehavior(port) && !RTPortUtils.isPublish(port)) {
                kind = RTPortKindEnum.RELAY;
            } else if (RTPortUtils.isBehavior(port) && !RTPortUtils.isWired(port) && !RTPortUtils.isPublish(port) && !RTPortUtils.isService(port)) {
                kind = RTPortKindEnum.SAP;
            }
        }
        return kind;
    }
}

