/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Capsule;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CanonicalPortDisplayEditPolicy
extends GraphicalEditPolicyEx
implements NotificationListener {
    public static final String CANONICAL_PORT_DISPLAY_ROLE = "CanonicalPortDisplay";
    private static final String DISPLAY_SERVICE_PORT = "displayServicePort";
    private View hostView;
    private Class capsule;
    private Property capsulePart;
    private boolean displayServicePort;

    public void activate() {
        this.initialisation();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.capsule, (NotificationListener)this);
        super.activate();
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.capsule, (NotificationListener)this);
        super.deactivate();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        DiagramEventBroker eventBorker = null;
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            eventBorker = DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return eventBorker;
    }

    protected void initialisation() {
        if (this.getHost() instanceof GraphicalEditPart) {
            Type type;
            this.hostView = ((GraphicalEditPart)this.getHost()).getNotationView();
            this.displayServicePort = NotationUtils.getBooleanValue((View)this.hostView, (String)DISPLAY_SERVICE_PORT, (boolean)true);
            if (this.hostView.getElement() instanceof Property) {
                this.capsulePart = (Property)this.hostView.getElement();
            }
            if (CapsulePartUtils.isCapsulePart((Property)this.capsulePart) && (type = this.capsulePart.getType()) instanceof Class && UMLUtil.getStereotypeApplication((Element)((Class)type), Capsule.class) != null) {
                this.capsule = (Class)type;
            }
        }
    }

    public void refresh() {
        this.createPortView();
        this.deletePortView();
        super.refresh();
    }

    private void deletePortView() {
        for (Object child : this.hostView.getChildren()) {
            if (!(child instanceof Node)) continue;
            EObject childElement = ((Node)child).getElement();
            if (childElement instanceof Port && !this.capsule.getOwnedPorts().contains((Object)childElement)) {
                this.deletePortView((Port)childElement);
                continue;
            }
            if (this.displayServicePort) continue;
            this.deletePortView((Port)childElement);
        }
    }

    private void createPortView() {
        this.initialisation();
        if (this.displayServicePort && this.capsule != null) {
            for (Port port : this.capsule.getOwnedPorts()) {
                this.getDiagramEventBroker().addNotificationListener((EObject)port, (NotificationListener)this);
                if (!RTPortUtils.isService((Port)port) || this.getPortView(port) != null) continue;
                this.displayPortView(port);
            }
        }
    }

    private View getPortView(Port port) {
        Node portView = null;
        Iterator iterator = this.hostView.getChildren().iterator();
        while (portView == null && iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof Node) || !((Node)child).getElement().equals(port)) continue;
            portView = (Node)child;
        }
        return portView;
    }

    protected void displayPortView(Port port) {
        CreateViewRequest request = this.getCreationViewRequest(port);
        Command command = this.getHost().getCommand((Request)request);
        CommandUtil.executeCommand((Command)command, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
    }

    protected CreateViewRequest getCreationViewRequest(Port port) {
        String semanticHint = ((IHintedType)UMLElementTypes.Port_3069).getSemanticHint();
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)port);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, false, this.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        return createViewRequest;
    }

    protected PreferencesHint getDiagramPreferencesHint() {
        return ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint();
    }

    public void notifyChanged(Notification notification) {
        Object feature;
        int type = notification.getEventType();
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        if (type == 3 && newValue instanceof Port && notifier instanceof Class && CapsuleUtils.isCapsule((Classifier)((Class)notifier))) {
            this.createPortView();
        }
        if (type == 4 && oldValue instanceof Port && notifier instanceof Class && CapsuleUtils.isCapsule((Classifier)((Class)notifier))) {
            this.deletePortView((Port)oldValue);
        }
        if (type == 1 && notifier instanceof Port && (feature = notification.getFeature()) != null && 47 == ((EStructuralFeature)feature).getFeatureID()) {
            if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                this.createPortView();
            } else {
                this.deletePortView((Port)notifier);
            }
        }
    }

    private void deletePortView(Port port) {
        View viewPort = this.getPortView(port);
        if (viewPort != null) {
            DeleteCommand command = new DeleteCommand(viewPort);
            CommandUtil.executeUnsafeCommand((ICommand)command, (Object)this.getHost());
        }
    }
}

