/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;

public class UMLRTLabelProvider
extends UMLFilteredLabelProvider {
    public final Map<String, String> typeIdtoIconPath = new HashMap<String, String>();
    protected static String ICON_PATH = "/icons/";
    protected static String RT_MESSAGE_IN_ICON = String.valueOf(ICON_PATH) + "protocolmessage_in.gif";
    protected static String RT_MESSAGE_IN_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_inout.gif";
    protected static String RT_MESSAGE_OUT_ICON = String.valueOf(ICON_PATH) + "protocolmessage_out.gif";
    protected static String RT_MESSAGE_UNDEFINED_ICON = String.valueOf(ICON_PATH) + "protocolmessage_undefined.gif";
    protected static final IItemLabelProvider labelProvider = new DelegatingItemLabelProvider();

    public UMLRTLabelProvider() {
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Capsule", String.valueOf(ICON_PATH) + "capsule.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.CapsulePart", String.valueOf(ICON_PATH) + "capsule_part.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolContainer", String.valueOf(ICON_PATH) + "protocol_container.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.Protocol", String.valueOf(ICON_PATH) + "protocol.png");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTConnector", String.valueOf(ICON_PATH) + "rt_connector.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTRExcludedElement", String.valueOf(ICON_PATH) + "rt_excludedElement.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTMessageSet", String.valueOf(ICON_PATH) + "rt_messageset.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.RTPort", String.valueOf(ICON_PATH) + "rt_port.gif");
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn", RT_MESSAGE_IN_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut", RT_MESSAGE_IN_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut", RT_MESSAGE_OUT_ICON);
        this.typeIdtoIconPath.put("org.eclipse.papyrusrt.umlrt.core.ProtocolMessage", RT_MESSAGE_UNDEFINED_ICON);
    }

    public Image getImage(Object element) {
        EObject semanticObject = EMFHelper.getEObject((Object)element);
        if (!(semanticObject instanceof Element)) {
            Activator.log.debug("Trying to display an UMLRT image for a non UML-RT element");
            return null;
        }
        String matchingTypeMatcher = this.getMatchingType(semanticObject);
        Image image = null;
        switch (matchingTypeMatcher) {
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageIn": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_IN_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.ProtocolMessageInOut": {
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", RT_MESSAGE_IN_OUT_ICON);
                break;
            }
            case "org.eclipse.papyrusrt.umlrt.core.RTMessageSet": {
                RTMessageKind kind = MessageSetUtils.getMessageKind((Object)semanticObject);
                if (kind == RTMessageKind.IN) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_in.gif");
                    break;
                }
                if (kind == RTMessageKind.OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_out.gif");
                    break;
                }
                if (kind == RTMessageKind.IN_OUT) {
                    image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", String.valueOf(ICON_PATH) + "rt_messageset_inout.gif");
                    break;
                }
                image = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", this.typeIdtoIconPath.get("org.eclipse.papyrusrt.umlrt.core.RTMessageSet"));
                break;
            }
            default: {
                image = this.getElementImage(matchingTypeMatcher, semanticObject);
            }
        }
        return image;
    }

    public String getText(Object element) {
        return labelProvider.getText(element);
    }

    protected String getMatchingType(EObject semanticObject) {
        for (IElementType type : UMLRTElementTypesEnumerator.getAllRTTypes()) {
            if (!(type instanceof ISpecializationType) || !((ISpecializationType)type).getMatcher().matches(semanticObject)) continue;
            return type.getId();
        }
        return null;
    }

    protected Image getElementImage(String id, EObject semanticObject) {
        String iconPath = this.typeIdtoIconPath.get(id);
        if (iconPath != null) {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrusrt.umlrt.tooling.ui", iconPath);
        }
        return null;
    }
}

