/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import java.util.LinkedHashMap;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.UMLRealTimePackage;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.CapsulePartKindObservableValue;
import org.eclipse.papyrusrt.umlrt.tooling.ui.widgets.PortRTKindObservableValue;
import org.eclipse.uml2.uml.Stereotype;

public class RTStereotypeModelElement
extends StereotypeModelElement {
    private EObject stereoApplication;

    public RTStereotypeModelElement(EObject stereoApplication, Stereotype stereotype, EditingDomain domain) {
        super(stereoApplication, stereotype, domain);
        this.stereoApplication = stereoApplication;
    }

    protected boolean isFeatureEditable(String propertyPath) {
        boolean editable = true;
        EStructuralFeature feature = this.getFeature(propertyPath);
        if (this.stereoApplication instanceof RTPort) {
            if ("kind".equals(propertyPath)) {
                editable = true;
            } else if (UMLRealTimePackage.eINSTANCE.getRTPort_IsNotification().equals(feature)) {
                editable = true;
            } else if (UMLRealTimePackage.eINSTANCE.getRTPort_IsWired().equals(feature)) {
                editable = true;
            } else if (UMLRealTimePackage.eINSTANCE.getRTPort_IsPublish().equals(feature)) {
                editable = false;
            }
        } else {
            editable = this.stereoApplication instanceof CapsulePart ? true : super.isFeatureEditable(propertyPath);
        }
        return editable;
    }

    public IObservable doGetObservable(String propertyPath) {
        Object observe = null;
        if ("kind".equals(propertyPath)) {
            if (this.stereoApplication instanceof RTPort) {
                observe = new PortRTKindObservableValue(this.stereoApplication, (TransactionalEditingDomain)this.domain);
            } else if (this.stereoApplication instanceof CapsulePart) {
                observe = new CapsulePartKindObservableValue(this.stereoApplication, (TransactionalEditingDomain)this.domain);
            }
        } else {
            observe = super.doGetObservable(propertyPath);
        }
        return observe;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        IStaticContentProvider provider = null;
        if ("kind".equals(propertyPath) && this.stereoApplication instanceof RTPort) {
            LinkedHashMap<RTPortKindEnum, String> map = new LinkedHashMap<RTPortKindEnum, String>(RTPortKindEnum.values().length);
            map.put(RTPortKindEnum.EXTERNAL, RTPortKindEnum.EXTERNAL.getLabel());
            map.put(RTPortKindEnum.INTERNAL, RTPortKindEnum.INTERNAL.getLabel());
            map.put(RTPortKindEnum.RELAY, RTPortKindEnum.RELAY.getLabel());
            map.put(RTPortKindEnum.SAP, RTPortKindEnum.SAP.getLabel());
            map.put(RTPortKindEnum.SPP, RTPortKindEnum.SPP.getLabel());
            provider = new StaticContentProvider(map.keySet().toArray());
        } else if ("kind".equals(propertyPath) && this.stereoApplication instanceof CapsulePart) {
            LinkedHashMap<CapsulePartKindEnum, String> map = new LinkedHashMap<CapsulePartKindEnum, String>(CapsulePartKindEnum.values().length);
            map.put(CapsulePartKindEnum.FIXED, CapsulePartKindEnum.FIXED.getLabel());
            map.put(CapsulePartKindEnum.OPTIONAL, CapsulePartKindEnum.OPTIONAL.getLabel());
            map.put(CapsulePartKindEnum.PLUGIN, CapsulePartKindEnum.PLUGIN.getLabel());
            provider = new StaticContentProvider(map.keySet().toArray());
        } else {
            provider = super.getContentProvider(propertyPath);
        }
        return provider;
    }
}

