/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.views.properties.creation.CreateInDialog;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractElementTypeBasedValueFactory
extends UMLPropertyEditorFactory {
    public AbstractElementTypeBasedValueFactory(EReference eReference) {
        super(eReference);
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        return objectsToValidate;
    }

    protected EObject createObjectInDifferentContainer(Control widget) {
        EObject protocolContainer = this.chooseNewContainer(widget);
        if (protocolContainer == null) {
            return null;
        }
        IElementType elementType = this.chooseElementType(widget);
        if (elementType == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)protocolContainer);
        if (service == null) {
            return null;
        }
        IClientContext clientContext = null;
        try {
            clientContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (clientContext == null) {
            return null;
        }
        ICommand editCommand = service.getEditCommand((IEditCommandRequest)new CreateElementRequest(protocolContainer, elementType));
        if (editCommand != null && editCommand.canExecute()) {
            try {
                CommandResult result;
                IStatus status = editCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (status != null && status.isOK() && (result = editCommand.getCommandResult()).getReturnValue() instanceof EObject) {
                    return (EObject)result.getReturnValue();
                }
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected EObject simpleCreateObject(Control widget) {
        EObject container = this.chooseNewContainer(widget);
        if (container == null) {
            return null;
        }
        IElementType elementType = this.chooseElementType(widget);
        if (elementType == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (service == null) {
            return null;
        }
        IClientContext clientContext = null;
        try {
            clientContext = TypeContext.getContext();
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        if (clientContext == null) {
            return null;
        }
        ICommand editCommand = service.getEditCommand((IEditCommandRequest)new CreateElementRequest(container, elementType));
        if (editCommand != null && editCommand.canExecute()) {
            try {
                CommandResult result;
                IStatus status = editCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (status != null && status.isOK() && (result = editCommand.getCommandResult()).getReturnValue() instanceof EObject) {
                    return (EObject)result.getReturnValue();
                }
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected EObject chooseNewContainer(Control widget) {
        EObject virtualElement = this.getVirtualElementToCreate();
        CreateInDialog dialog = new CreateInDialog(widget.getShell(), (Object)virtualElement);
        dialog.setProviders(this.containerContentProvider, (IStaticContentProvider)this.referenceContentProvider, this.containerLabelProvider, this.referenceLabelProvider);
        dialog.setTitle(this.getCreationDialogTitle());
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        return dialog.getContainer();
    }

    protected abstract EObject getVirtualElementToCreate();

    protected abstract IElementType chooseElementType(Control var1);
}

