/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.codegen.base.codesync.ChangeObject;
import org.eclipse.papyrus.codegen.base.codesync.ManageChangeEvents;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.utils.CodeGenUtils;
import org.eclipse.papyrusrt.codegen.utils.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.UML2xtumlrtModelTranslator;
import org.eclipse.uml2.uml.Class;

public abstract class AbstractUMLRTGenerator {
    private boolean regenerate = false;

    protected AbstractUMLRTGenerator() {
    }

    public void setRegenerate(boolean flag) {
        this.regenerate = flag;
    }

    public IStatus generate(List<EObject> elements, String top) {
        UML2xtumlrtModelTranslator translator = new UML2xtumlrtModelTranslator();
        CppCodePattern cpp = new CppCodePattern(translator);
        CppCodeGenerator codegen = new CppCodeGenerator(cpp);
        Class topCapsule = CodeGenUtils.findCapsule((EObject)elements.get(0), (String)top);
        if (topCapsule == null) {
            return new Status(4, "org.eclipse.papyrusrt.codegen", "Top capsule not found");
        }
        codegen.setTop(topCapsule);
        cpp.setTop(topCapsule);
        if (this.regenerate) {
            codegen.getChangeTracker().resetAll();
        }
        ArrayList<ChangeObject> changes = new ArrayList<ChangeObject>();
        HashMap<File, ArrayList<EObject>> targets = new HashMap<File, ArrayList<EObject>>();
        HashMap<File, File> outputFolders = new HashMap<File, File>();
        boolean first = true;
        ResourceSet resourceSet = null;
        for (EObject eobj : elements) {
            this.getChanges(changes, eobj);
            File modelFolder = this.getModelFolder(eobj);
            ArrayList<EObject> list = (ArrayList<EObject>)targets.get(modelFolder);
            if (list == null) {
                list = new ArrayList<EObject>();
                targets.put(modelFolder, list);
            }
            list.add(eobj);
            File outputFolder = (File)outputFolders.get(modelFolder);
            if (outputFolder == null) {
                outputFolder = this.getOutputFolder(eobj);
                outputFolders.put(modelFolder, outputFolder);
            }
            if (first || resourceSet == null) {
                first = false;
                resourceSet = eobj.eResource().getResourceSet();
                continue;
            }
            if (resourceSet == eobj.eResource().getResourceSet()) continue;
            CodeGenPlugin.warning((String)"Target elements belong to different resource sets. This may result in errors during generation.");
        }
        codegen.getChangeTracker().addChanges(changes);
        Collection<EObject> changedElements = codegen.getChangeTracker().getAllChanged();
        RTSModelLibraryUtils.setResourceSet(resourceSet);
        RTSModelLibraryUtils.loadRTSModelLibrary();
        MultiStatus status = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, "UML-RT Code Generator Invoked", null);
        long start = System.currentTimeMillis();
        if (targets.isEmpty()) {
            status.add(CodeGenPlugin.error((String)"Selection must contain at least one model element"));
        } else {
            try {
                for (Map.Entry entry : targets.entrySet()) {
                    File modelFolder = (File)entry.getKey();
                    Path path = modelFolder.toPath();
                    File outputFolder = (File)outputFolders.get(modelFolder);
                    translator.setTargets((List)entry.getValue());
                    translator.setOutputPath(path);
                    translator.setChangeSet(changedElements);
                    try {
                        status.addAll(translator.generate());
                    }
                    catch (Throwable t) {
                        status.add(CodeGenPlugin.error((String)"Error during translation", (Throwable)t));
                        t.printStackTrace(System.err);
                        continue;
                    }
                    List translated = translator.getAllGenerated();
                    if (translated == null || translated.isEmpty()) continue;
                    cpp.setOutputFolder(outputFolder);
                    cpp.setModelFolder(modelFolder);
                    codegen.setTargets(translated);
                    try {
                        status.addAll(codegen.generate());
                    }
                    catch (Throwable t) {
                        status.add(CodeGenPlugin.error((String)"Error during generation", (Throwable)t));
                        t.printStackTrace(System.err);
                        continue;
                    }
                    long writeStart = System.currentTimeMillis();
                    if (cpp.write()) {
                        status.add(CodeGenPlugin.info((String)("Updated generated files " + (System.currentTimeMillis() - writeStart) + "ms")));
                        continue;
                    }
                    status.add(CodeGenPlugin.error((String)"Failed to write generated model to disk"));
                }
            }
            catch (Throwable t) {
                CodeGenPlugin.error((String)"error during codegen action", (Throwable)t);
                status.add(CodeGenPlugin.error((Throwable)t));
            }
        }
        String message = "Generation " + (status.getSeverity() <= 1 ? "complete" : "error") + ", elapsed time " + (System.currentTimeMillis() - start) + " ms";
        MultiStatus result = new MultiStatus("org.eclipse.papyrusrt.codegen", 1, message, null);
        result.addAll((IStatus)status);
        return result;
    }

    protected void getChanges(List<ChangeObject> changes, EObject object) {
        if (CodeGenPlugin.isStandalone()) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)object);
        if (domain != null) {
            EList changeList = ManageChangeEvents.getChangeList((TransactionalEditingDomain)domain);
            ManageChangeEvents.stopRecording((TransactionalEditingDomain)domain);
            ManageChangeEvents.initChangeList((TransactionalEditingDomain)domain, (boolean)true);
            if (changeList != null) {
                changes.addAll((Collection<ChangeObject>)changeList);
            }
        }
    }

    protected abstract File getModelFolder(EObject var1);

    protected abstract File getOutputFolder(EObject var1);
}

