/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrusrt.codegen.instance.model.ICapsuleInstance;
import org.eclipse.papyrusrt.codegen.instance.model.PortInstance;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;

public class ConnectorReporter {
    private final ICapsuleInstance capsule;
    private final Map<Connector, List<Connection>> connections = new LinkedHashMap<Connector, List<Connection>>();
    private final List<ConnectorReporter> inners = new ArrayList<ConnectorReporter>();

    public ConnectorReporter(ICapsuleInstance capsule) {
        this.capsule = capsule;
    }

    public void record(Connector conn, PortInstance.FarEnd far0, PortInstance.FarEnd far1) {
        List<Connection> conns = this.connections.get(conn);
        if (conns == null) {
            conns = new ArrayList<Connection>();
            this.connections.put(conn, conns);
        }
        conns.add(new Connection(far0, far1));
    }

    public ConnectorReporter createInner(ICapsuleInstance sub) {
        ConnectorReporter inner = new ConnectorReporter(sub);
        this.inners.add(inner);
        return inner;
    }

    public void log(PrintStream stm) {
        for (Map.Entry<Connector, List<Connection>> entry : this.connections.entrySet()) {
            stm.append(this.capsule.getQualifiedName('.'));
            stm.append('.');
            stm.append(entry.getKey().getName());
            stm.append('\n');
            for (Connection conn : entry.getValue()) {
                stm.append("    ");
                stm.append(conn.far0.toString());
                stm.append(" <-> ");
                stm.append(conn.far1.toString());
                stm.append('\n');
            }
        }
        for (ConnectorReporter inner : this.inners) {
            inner.log(stm);
        }
    }

    public void log(File outFolder) {
        try (PrintStream stm = null;){
            try {
                File file = new File(outFolder, String.valueOf(this.capsule.getType().getName()) + "-connections.log");
                stm = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                this.log(stm);
            }
            catch (IOException iOException) {
                if (stm != null) {
                    stm.close();
                }
            }
        }
    }

    private static class Connection {
        public final PortInstance.FarEnd far0;
        public final PortInstance.FarEnd far1;

        public Connection(PortInstance.FarEnd far0, PortInstance.FarEnd far1) {
            this.far0 = far0;
            this.far1 = far1;
        }
    }
}

