/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.codegen.base.codesync.ChangeObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.ChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.utils.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.codegen.utils.UMLRealTimeProfileUtil;
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.UML2xtumlrtModelTranslator;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UML2ChangeTracker
implements ChangeTracker {
    private static UML2ChangeTracker ACTIVE_INSTANCE = null;
    private static Map<Resource, Multimap<CppCodeGenerator.Kind, EObject>> alreadyGenerated = new HashMap<Resource, Multimap<CppCodeGenerator.Kind, EObject>>();
    private static Map<Resource, Multimap<CppCodeGenerator.Kind, EObject>> changed = new HashMap<Resource, Multimap<CppCodeGenerator.Kind, EObject>>();
    private UML2xtumlrtModelTranslator translator;
    private Class top;

    public UML2ChangeTracker(UML2xtumlrtModelTranslator translator) {
        this.translator = translator;
    }

    public UML2ChangeTracker(UML2xtumlrtModelTranslator translator, Class top) {
        this.translator = translator;
        this.top = top;
    }

    @Override
    public void setTop(Class top) {
        this.top = top;
    }

    public static void setActiveInstance(UML2ChangeTracker trackerInstance) {
        ACTIVE_INSTANCE = trackerInstance;
    }

    public static UML2ChangeTracker getActiveInstance() {
        return ACTIVE_INSTANCE;
    }

    @Override
    public void prune(Map<CppCodeGenerator.GeneratorKey, AbstractCppGenerator> generators) {
        Iterator<Map.Entry<CppCodeGenerator.GeneratorKey, AbstractCppGenerator>> iterator = generators.entrySet().iterator();
        while (iterator.hasNext()) {
            File output;
            Map.Entry<CppCodeGenerator.GeneratorKey, AbstractCppGenerator> next = iterator.next();
            CppCodeGenerator.GeneratorKey key = next.getKey();
            Element umlElement = this.translator.getSource((CommonElement)((NamedElement)key.object));
            AbstractCppGenerator generator = next.getValue();
            String outputPath = generator.cpp.getOutputFolder().getAbsolutePath();
            boolean shouldRegenerate = false;
            for (FileName f : generator.getGeneratedFilenames()) {
                File output2 = new File(String.valueOf(outputPath) + File.separator + f.getAbsolutePath() + ".cc");
                if (!output2.exists()) {
                    shouldRegenerate = true;
                    break;
                }
                File header = new File(String.valueOf(outputPath) + File.separator + f.getIncludePath());
                if (header.exists()) continue;
                shouldRegenerate = true;
                break;
            }
            if (key.kind == CppCodeGenerator.Kind.Structural && !(output = new File(String.valueOf(outputPath) + File.separator + generator.cpp.getMainName() + ".cc")).exists()) {
                shouldRegenerate = true;
            }
            if (shouldRegenerate || !this.alreadyGeneratedContains(key.kind, (EObject)umlElement) || this.changedContains(key.kind, (EObject)umlElement)) continue;
            if (key.kind == CppCodeGenerator.Kind.Capsule) {
                boolean portWithChangedProtocol = false;
                for (Port umlPort : UMLRealTimeProfileUtil.getAllRTPorts((Class)((Class)umlElement))) {
                    Package protocol = UMLRealTimeProfileUtil.getProtocol((Port)umlPort);
                    if (!this.changedContains(CppCodeGenerator.Kind.Protocol, (EObject)protocol)) continue;
                    portWithChangedProtocol = true;
                    break;
                }
                if (portWithChangedProtocol) continue;
                CodeGenPlugin.getLogger().log(Level.INFO, "Pruning " + ((org.eclipse.uml2.uml.NamedElement)umlElement).getQualifiedName() + " from generation.");
                iterator.remove();
                continue;
            }
            CodeGenPlugin.getLogger().log(Level.INFO, "Pruning " + ((org.eclipse.uml2.uml.NamedElement)umlElement).getQualifiedName() + " from generation.");
            iterator.remove();
        }
    }

    @Override
    public void consumeChanges(Map<CppCodeGenerator.GeneratorKey, AbstractCppGenerator> generators) {
        for (CppCodeGenerator.GeneratorKey gk : generators.keySet()) {
            Element umlElement = this.translator.getSource((CommonElement)((NamedElement)gk.object));
            this.removeChanged(gk.kind, (EObject)umlElement);
        }
    }

    private boolean alreadyGeneratedContains(CppCodeGenerator.Kind kind, EObject object) {
        Multimap<CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = alreadyGenerated.get(resource)) != null) {
            return multimap.containsEntry((Object)kind, (Object)object);
        }
        return false;
    }

    @Override
    public void addAlreadyGenerated(CppCodeGenerator.Kind kind, NamedElement object) {
        Resource resource;
        Element source = this.translator.getSource((CommonElement)object);
        if (source != null && (resource = source.eResource()) != null) {
            HashMultimap multimap = alreadyGenerated.get(resource);
            if (multimap == null) {
                multimap = HashMultimap.create();
                alreadyGenerated.put(resource, (Multimap<CppCodeGenerator.Kind, EObject>)multimap);
            }
            multimap.put((Object)kind, (Object)source);
        }
    }

    private boolean changedContains(CppCodeGenerator.Kind kind, EObject object) {
        Multimap<CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = changed.get(resource)) != null) {
            return multimap.containsEntry((Object)kind, (Object)object);
        }
        return false;
    }

    @Override
    public Collection<EObject> getAllChanged() {
        Collection<Multimap<CppCodeGenerator.Kind, EObject>> allMultiMaps;
        ArrayList<EObject> all = new ArrayList<EObject>();
        if (changed != null && (allMultiMaps = changed.values()) != null) {
            for (Multimap<CppCodeGenerator.Kind, EObject> map : allMultiMaps) {
                all.addAll(map.values());
            }
        }
        return all;
    }

    private void removeChanged(CppCodeGenerator.Kind kind, EObject object) {
        Multimap<CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = changed.get(resource)) != null) {
            multimap.remove((Object)kind, (Object)object);
        }
    }

    @Override
    public void addChanges(List<ChangeObject> changeList) {
        if (changeList != null) {
            ChangeCollector changeCollector = new ChangeCollector(changed);
            HashSet<EObject> alreadyAdded = new HashSet<EObject>();
            for (ChangeObject change : changeList) {
                EObject target = change.eObject;
                if (target == null || alreadyAdded.contains(target)) continue;
                alreadyAdded.add(target);
                changeCollector.doSwitch(target);
            }
        }
    }

    @Override
    public void closeResource(Resource resource) {
        if (changed.remove(resource) != null) {
            CodeGenPlugin.getLogger().log(Level.INFO, "Cleaning up changed map for resource: " + resource.getURI().toString());
        }
        if (alreadyGenerated.remove(resource) != null) {
            CodeGenPlugin.getLogger().log(Level.INFO, "Cleaning up already generated map for resource: " + resource.getURI().toString());
        }
    }

    @Override
    public void resetAll() {
        alreadyGenerated = new HashMap<Resource, Multimap<CppCodeGenerator.Kind, EObject>>();
        changed = new HashMap<Resource, Multimap<CppCodeGenerator.Kind, EObject>>();
    }

    private class ChangeCollector
    extends UMLSwitch<Boolean> {
        final Map<Resource, Multimap<CppCodeGenerator.Kind, EObject>> changed;

        public ChangeCollector(Map<Resource, Multimap<CppCodeGenerator.Kind, EObject>> changed) {
            this.changed = changed;
        }

        public Boolean defaultCase(EObject object) {
            EObject container = object.eContainer();
            if (container != null) {
                this.doSwitch(container);
            }
            return Boolean.TRUE;
        }

        public Boolean casePackage(Package object) {
            CommonElement xtumlrtElement;
            if (UMLRealTimeProfileUtil.isProtocolContainer((Element)object) && (xtumlrtElement = UML2ChangeTracker.this.translator.getGenerated((Element)object)) instanceof NamedElement && !RTSModelLibraryUtils.isSystemElement((CommonElement)xtumlrtElement)) {
                this.createChange(CppCodeGenerator.Kind.Protocol, (EObject)object);
                for (Element element : object.getModel().getOwnedElements()) {
                    if (!UMLRealTimeProfileUtil.isCapsule((Element)element)) continue;
                    for (Port umlPort : UMLRealTimeProfileUtil.getAllRTPorts((Class)((Class)element))) {
                        if (UMLRealTimeProfileUtil.getProtocol((Port)umlPort) != object) continue;
                        this.doSwitch((EObject)element);
                    }
                }
            }
            return Boolean.TRUE;
        }

        public Boolean caseDataType(DataType object) {
            this.createChange(CppCodeGenerator.Kind.BasicClass, (EObject)object);
            return Boolean.TRUE;
        }

        public Boolean caseBehavior(Behavior object) {
            EObject container = object.eContainer();
            if (container instanceof Class) {
                this.createClassChange((Class)container);
            }
            return Boolean.TRUE;
        }

        public Boolean caseClass(Class object) {
            this.createClassChange(object);
            if (UMLRealTimeProfileUtil.isCapsule((Element)object)) {
                this.createChange(CppCodeGenerator.Kind.Structural, (EObject)UML2ChangeTracker.this.top);
            }
            return Boolean.TRUE;
        }

        private void createClassChange(Class object) {
            if (!UMLRealTimeProfileUtil.isCapsule((Element)object)) {
                this.createChange(CppCodeGenerator.Kind.BasicClass, (EObject)object);
                return;
            }
            this.createChange(CppCodeGenerator.Kind.Capsule, (EObject)object);
            Behavior behaviour = object.getClassifierBehavior();
            if (behaviour == null) {
                behaviour = object.getOwnedBehavior(null);
            }
            if (behaviour instanceof StateMachine) {
                this.createChange(CppCodeGenerator.Kind.StateMachine, (EObject)behaviour);
            } else {
                this.createChange(CppCodeGenerator.Kind.EmptyStateMachine, (EObject)object);
            }
        }

        private void createChange(CppCodeGenerator.Kind kind, EObject object) {
            Resource resource;
            if (object != null && (resource = object.eResource()) != null) {
                HashMultimap multimap = this.changed.get(resource);
                if (multimap == null) {
                    multimap = HashMultimap.create();
                    this.changed.put(resource, (Multimap<CppCodeGenerator.Kind, EObject>)multimap);
                }
                multimap.put((Object)kind, (Object)object);
            }
        }
    }
}

