/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.TypeDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class Type {
    private final Element element;
    private final CVQualifier cvQualifier;
    private final List<Pointer> pointerSpec = new ArrayList<Pointer>();
    private final List<Expression> arrayBounds = new ArrayList<Expression>();

    public Type(Element element) {
        this(CVQualifier.UNQUALIFIED, element);
    }

    private Type(CVQualifier cvQualifier, Element element) {
        this.element = element;
        this.cvQualifier = cvQualifier;
    }

    public Type ref() {
        Type copy = this.deepCopy();
        copy.pointerSpec.add(Pointer.REFERENCE);
        return copy;
    }

    public Type ptr() {
        Type copy = this.deepCopy();
        copy.pointerSpec.add(Pointer.POINTER);
        return copy;
    }

    public Type constPtr() {
        Type copy = this.deepCopy();
        copy.pointerSpec.add(Pointer.CONST_POINTER);
        return copy;
    }

    public Type volatilePtr() {
        Type copy = this.deepCopy();
        copy.pointerSpec.add(Pointer.VOLATILE_POINTER);
        return copy;
    }

    public Type constVolatilePtr() {
        Type copy = this.deepCopy();
        copy.pointerSpec.add(Pointer.CONST_VOLATILE_POINTER);
        return copy;
    }

    public Type arrayOf(Expression bound) {
        Type copy = this.deepCopy();
        copy.arrayBounds.add(bound);
        return copy;
    }

    public Type const_() {
        return this.deepCopy(CVQualifier.CONST);
    }

    public Type volatile_() {
        return this.deepCopy(CVQualifier.VOLATILE);
    }

    public Type constVolatile() {
        return this.deepCopy(CVQualifier.CONST_VOLATILE);
    }

    public Type dereference() {
        Type copy = new Type(this.cvQualifier, this.element);
        if (this.arrayBounds.size() > 0) {
            copy.pointerSpec.addAll(this.pointerSpec);
            int i = 0;
            while (i < this.arrayBounds.size() - 1) {
                copy.arrayBounds.add(this.arrayBounds.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.pointerSpec.size() - 1) {
                copy.pointerSpec.add(this.pointerSpec.get(i));
                ++i;
            }
        }
        return copy;
    }

    public Element getElement() {
        return this.element;
    }

    public boolean isArray() {
        return !this.arrayBounds.isEmpty();
    }

    public boolean isIndirect() {
        if (this.arrayBounds.size() > 0) {
            return true;
        }
        switch (this.pointerSpec.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.pointerSpec.get(0) != Pointer.REFERENCE;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        if (!this.element.equals(other.element) || !this.cvQualifier.equals((Object)other.cvQualifier)) {
            return false;
        }
        if (this.pointerSpec.size() != other.pointerSpec.size() || this.arrayBounds.size() != other.arrayBounds.size()) {
            return false;
        }
        int i = 0;
        while (i < this.pointerSpec.size()) {
            if (!this.pointerSpec.get(i).equals((Object)other.pointerSpec.get(i))) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.arrayBounds.size()) {
            if (!this.arrayBounds.get(i).equals(other.arrayBounds.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.cvQualifier.ordinal() ^ this.pointerSpec.size() ^ this.arrayBounds.size();
    }

    private Type deepCopy() {
        return this.deepCopy(this.cvQualifier);
    }

    private Type deepCopy(CVQualifier cvQualifier) {
        Type copy = new Type(cvQualifier, this.element);
        copy.pointerSpec.addAll(this.pointerSpec);
        copy.arrayBounds.addAll(this.arrayBounds);
        return copy;
    }

    public boolean addDependencies(DependencyList deps) {
        return deps.add(new TypeDependency(this));
    }

    public boolean write(CppFormatter fmt, Name name) {
        return this.cvQualifier.write(fmt) && fmt.space() && this.element.write(fmt, name, this.pointerSpec, this.arrayBounds);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.cvQualifier != CVQualifier.UNQUALIFIED) {
            str.append(this.cvQualifier.toString());
            str.append(' ');
        }
        str.append(this.element.toString());
        str.append(' ');
        for (Pointer ptr : this.pointerSpec) {
            str.append(ptr.toString());
        }
        int i = this.arrayBounds.size();
        while (i > 0) {
            str.append("[]");
            --i;
        }
        return str.toString();
    }

    public static enum CVQualifier {
        CONST,
        VOLATILE,
        CONST_VOLATILE,
        UNQUALIFIED;


        public boolean write(CppFormatter fmt) {
            switch (this) {
                case CONST: {
                    return fmt.write("const");
                }
                case VOLATILE: {
                    return fmt.write("volatile");
                }
                case CONST_VOLATILE: {
                    return fmt.write("const volatile");
                }
            }
            return fmt.markNoText();
        }
    }

    public static enum Pointer {
        REFERENCE("&"),
        POINTER("*"),
        CONST_POINTER("* const"),
        VOLATILE_POINTER("* volatile"),
        CONST_VOLATILE_POINTER("* const volatile");

        private final String syntax;

        private Pointer(String syntax) {
            this.syntax = syntax;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.syntax);
        }

        public String toString() {
            return this.syntax;
        }
    }
}

