/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.dep;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class DependencyList
implements Iterable<Dependency> {
    private final Set<Dependency> deps = new TreeSet<Dependency>();

    @Override
    public Iterator<Dependency> iterator() {
        return this.deps.iterator();
    }

    public boolean add(Dependency dep) {
        if (dep != null) {
            this.deps.add(dep);
        }
        return true;
    }

    public boolean add(DependencyList depList) {
        for (Dependency dep : depList.deps) {
            if (this.add(dep)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.deps.isEmpty();
    }

    public boolean write(CppFormatter fmt) {
        return this.write(null, fmt);
    }

    public boolean write(ElementList container, CppFormatter fmt) {
        ArrayList<Dependency> written = new ArrayList<Dependency>();
        block0: for (Dependency dep : this.deps) {
            for (Dependency d : written) {
                if (dep.isProvidedBy(d)) continue block0;
            }
            if (!(container != null && container.equals(dep.getHeader()) || dep.write(fmt))) {
                return false;
            }
            if (dep instanceof DependencyBlob) continue;
            written.add(dep);
        }
        return true;
    }
}

