/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class CppEnum
extends NamedElement
implements IUserElement,
IGeneratable {
    private final NamedElement context;
    private final Expression firstLiteral;
    private final List<Enumerator> enumerators = new ArrayList<Enumerator>();

    public CppEnum(String ident) {
        this(null, ident, null);
    }

    public CppEnum(NamedElement context, String ident, Expression firstLiteral) {
        super(ident);
        this.context = context;
        this.firstLiteral = firstLiteral;
    }

    public void add(Enumerator enumerator) {
        if (this.context != null) {
            enumerator.setParent(this.context);
        }
        this.enumerators.add(enumerator);
    }

    public Enumerator add(String ident) {
        Enumerator enumerator;
        Enumerator enumerator2 = enumerator = this.firstLiteral == null || !this.enumerators.isEmpty() ? new Enumerator(ident) : new Enumerator(ident, this.firstLiteral);
        if (this.context != null) {
            enumerator.setParent(this.context);
        }
        this.enumerators.add(enumerator);
        return enumerator;
    }

    public int getOrderKey(Enumerator enumerator) {
        return this.enumerators.indexOf(enumerator);
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Enumerator enumerator : this.enumerators) {
            if (enumerator.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        return this.addDependencies(deps.decl());
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!(fmt.write("enum") && fmt.space() && fmt.write(this.getName()) && fmt.openBrace())) {
            return false;
        }
        boolean first = true;
        for (Enumerator enumerator : this.enumerators) {
            if (first) {
                first = false;
            } else if (!fmt.write(',') || !fmt.newline()) {
                return false;
            }
            if (enumerator.write(fmt)) continue;
            return false;
        }
        return fmt.closeBrace(false) && fmt.terminate();
    }

    @Override
    public boolean write(CppWriter out) {
        return this.write(out.decl());
    }
}

