/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MacroParameter;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class Macro
extends NamedElement
implements IUserElement {
    private List<MacroParameter> parameters = null;
    private final Expression expr;

    public Macro(String ident) {
        this(ident, null);
    }

    public Macro(String ident, Expression expr) {
        super(ident);
        this.expr = expr;
    }

    public boolean expectsArguments() {
        return this.parameters != null;
    }

    public Expression getReplacement() {
        return this.expr;
    }

    public void addParameter(MacroParameter param) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<MacroParameter>();
        }
        if (param != null) {
            this.parameters.add(param);
        }
    }

    public void addParameters(MacroParameter ... params) {
        if (params == null) {
            this.addParameter(null);
        } else {
            MacroParameter[] macroParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                MacroParameter param = macroParameterArray[n2];
                this.addParameter(param);
                ++n2;
            }
        }
    }

    public boolean addDependencies(DependencyList deps) {
        return this.expr == null ? true : this.expr.addDependencies(deps);
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        return this.addDependencies(deps.decl());
    }

    public boolean write(CppFormatter fmt) {
        if (!(fmt.write("#define") && fmt.space() && fmt.write(this.getName()))) {
            return false;
        }
        if (this.parameters != null) {
            if (!fmt.write('(')) {
                return false;
            }
            boolean first = true;
            for (MacroParameter param : this.parameters) {
                if (first) {
                    first = false;
                } else if (!fmt.write(',')) {
                    return false;
                }
                if (fmt.space() && param.write(fmt)) continue;
                return false;
            }
            if (!fmt.spaceUnless('(') || !fmt.write(')')) {
                return false;
            }
        }
        if (this.expr == null) {
            return fmt.newline();
        }
        return fmt.space() && fmt.write('(') && fmt.space() && this.expr.write(fmt) && fmt.space() && fmt.write(')') && fmt.newline();
    }

    @Override
    public boolean write(CppWriter out) {
        return this.write(out.decl());
    }
}

