/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class TypeBlob
extends Type {
    private String typeStr;

    public TypeBlob(String typeStr) {
        super(new TypeBlobElement(typeStr));
        this.typeStr = typeStr;
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public boolean write(CppFormatter fmt) {
        return fmt.write(this.typeStr);
    }

    private static class TypeBlobElement
    extends Element {
        String typeStr;

        public TypeBlobElement(String typeStr) {
            super(null);
            this.typeStr = typeStr;
        }

        @Override
        public Type getType() {
            return new Type(this);
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.typeStr);
        }

        @Override
        public boolean write(CppFormatter fmt, Name name, List<Type.Pointer> pointerSpec, List<Expression> arrayBounds) {
            if (!this.write(fmt) || !fmt.pendingSpace()) {
                return false;
            }
            boolean first = true;
            for (Type.Pointer ptr : pointerSpec) {
                if (first) {
                    first = false;
                } else if (!fmt.space()) {
                    return false;
                }
                if (ptr.write(fmt)) continue;
                return false;
            }
            if (!fmt.pendingSpace() || !fmt.write(name)) {
                return false;
            }
            for (Expression bound : arrayBounds) {
                if (fmt.write('[') && (bound == null || bound.write(fmt)) && fmt.write(']')) continue;
                return false;
            }
            return true;
        }
    }
}

