/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class BinaryOperation
extends Expression {
    private final Operator operator;
    private final Expression lhs;
    private final Expression rhs;

    public BinaryOperation(Expression lhs, Operator operator, Expression rhs) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    protected Type createType() {
        return this.lhs.getType();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return this.operator.precedence;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.lhs.addDependencies(deps) && this.rhs.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.lhs.write(fmt, this) && fmt.space() && this.operator.write(fmt) && fmt.space() && this.rhs.write(fmt, this);
    }

    public static enum Operator {
        ASSIGN('=', Expression.Precedence.Precedence15),
        ADD('+', Expression.Precedence.Precedence06),
        SUBTRACT('-', Expression.Precedence.Precedence06),
        MULTIPLY('*', Expression.Precedence.Precedence05),
        DIVIDE('/', Expression.Precedence.Precedence05),
        BITWISE_OR('|', Expression.Precedence.Precedence12),
        BITWISE_AND('&', Expression.Precedence.Precedence10);

        private final char token;
        public final Expression.Precedence precedence;

        private Operator(char token, Expression.Precedence precedence) {
            this.token = token;
            this.precedence = precedence;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.token);
        }
    }
}

