/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class UnaryOperation
extends Expression {
    private final Operator operator;
    private final Expression expr;

    public UnaryOperation(Operator operator, Expression expr) {
        this.operator = operator;
        this.expr = expr;
    }

    @Override
    protected Type createType() {
        return this.operator.boolean_op ? PrimitiveType.BOOL : this.expr.getType();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return this.operator.precedence;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.expr.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (this.operator.before) {
            return fmt.write(this.operator.syntax) && (!this.operator.separator || fmt.space()) && this.expr.write(fmt, this);
        }
        return this.expr.write(fmt, this) && (!this.operator.separator || fmt.space()) && fmt.write(this.operator.syntax);
    }

    public static enum Operator {
        PRE_INCREMENT("++", Expression.Precedence.Precedence03, true),
        PRE_DECREMENT("--", Expression.Precedence.Precedence03, true),
        POST_INCREMENT("++", Expression.Precedence.Precedence02),
        POST_DECREMENT("--", Expression.Precedence.Precedence02),
        LOGICAL_NOT("!", Expression.Precedence.Precedence03, true, true, true),
        BITWISE_NOT("~", Expression.Precedence.Precedence03, true);

        public final Expression.Precedence precedence;
        public final boolean before;
        public final boolean separator;
        public final boolean boolean_op;
        private final String syntax;

        private Operator(String syntax, Expression.Precedence p) {
            this(syntax, p, false);
        }

        private Operator(String syntax, Expression.Precedence p, boolean before) {
            this(syntax, p, before, false);
        }

        private Operator(String syntax, Expression.Precedence p, boolean before, boolean separator) {
            this(syntax, p, before, separator, false);
        }

        private Operator(String syntax, Expression.Precedence p, boolean before, boolean separator, boolean boolean_op) {
            this.syntax = syntax;
            this.precedence = p;
            this.before = before;
            this.separator = separator;
            this.boolean_op = boolean_op;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.syntax);
        }
    }
}

