/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.IForwardDeclarable;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppEnum;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.DeclarationBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Function;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Typedef;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class CppClass
extends NamedElement
implements IForwardDeclarable,
IUserElement {
    private Kind kind;
    private final List<BaseClassSpecifier> bases = new ArrayList<BaseClassSpecifier>();
    private final List<Member> ctors = new ArrayList<Member>();
    private final List<Member> members = new ArrayList<Member>();

    public CppClass(String ident) {
        this(Kind.CLASS, ident);
    }

    public CppClass(Kind kind, String ident) {
        super(ident);
        this.kind = kind;
    }

    public CppClass(UserElement.GenerationTarget genTarget, String ident) {
        this(genTarget, Kind.CLASS, ident);
    }

    public CppClass(UserElement.GenerationTarget genTarget, Kind kind, String ident) {
        super(genTarget, ident);
        this.kind = kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void addBase(Access access, NamedElement base) {
        this.bases.add(new BaseClassSpecifier(access, base, false));
    }

    public void addVirtualBase(Access access, NamedElement base) {
        this.bases.add(new BaseClassSpecifier(access, base, true));
    }

    public void addMember(Visibility visibility, Constructor ctor) {
        ctor.setCppClass(this);
        this.ctors.add(new Member(false, visibility, ctor));
    }

    public void addMember(Visibility visibility, MemberFunction function) {
        function.setParent(this);
        this.members.add(new Member(false, visibility, function));
    }

    public void addMember(Visibility visibility, MemberField field) {
        field.setParent(this);
        this.members.add(new Member(false, visibility, field));
    }

    public void addMember(Visibility visibility, CppClass cls) {
        cls.setParent(this);
        this.members.add(new Member(false, visibility, cls));
    }

    public void addMember(Visibility visibility, CppEnum enm) {
        enm.setParent(this);
        this.members.add(new Member(false, visibility, enm));
    }

    public void addMember(Visibility visibility, Typedef typedef) {
        typedef.setParent(this);
        this.members.add(new Member(false, visibility, typedef));
    }

    public void addStaticMember(Visibility visibility, MemberFunction function) {
        function.setParent(this);
        this.members.add(new Member(true, visibility, function));
    }

    public void addStaticMember(Visibility visibility, MemberField field) {
        field.setParent(this);
        this.members.add(new Member(true, visibility, field));
    }

    public void addFriendFunction(Function function) {
        function.setFriend();
        this.members.add(new Member(false, Visibility.PUBLIC, function));
    }

    public void addDeclarationBlob(Visibility visibility, DeclarationBlob declBlob) {
        this.members.add(new Member(false, visibility, declBlob));
    }

    private boolean addDependencies(DependencyList deps) {
        for (BaseClassSpecifier base : this.bases) {
            if (base.addDependencies(deps)) continue;
            return false;
        }
        for (Member ctor : this.ctors) {
            if (ctor.addDependencies(deps)) continue;
            return false;
        }
        for (Member member : this.members) {
            if (member.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        switch (this.getGenerationTarget()) {
            case DECL_ONLY: {
                return this.addDependencies(deps.decl());
            }
            case DEFN_ONLY: {
                return this.addDependencies(deps.defn());
            }
        }
        for (BaseClassSpecifier base : this.bases) {
            if (base.addDependencies(deps.decl())) continue;
            return false;
        }
        for (Member ctor : this.ctors) {
            if (ctor.addDependencies(deps)) continue;
            return false;
        }
        for (Member member : this.members) {
            if (member.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IForwardDeclarable o) {
        if (!(o instanceof CppClass)) {
            return Integer.compare(this.hashCode(), o.hashCode());
        }
        CppClass other = (CppClass)o;
        int cmp = this.kind.compareTo(other.kind);
        if (cmp != 0) {
            return cmp;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean writeForwardDeclaration(CppFormatter fmt) {
        return this.kind.write(fmt) && fmt.space() && fmt.write(this.getName()) && fmt.terminate();
    }

    private boolean writeBaseClassSpecifierList(CppFormatter fmt) {
        if (this.bases.isEmpty()) {
            return true;
        }
        if (!fmt.space()) {
            return false;
        }
        int separator = 58;
        for (BaseClassSpecifier base : this.bases) {
            if (!(fmt.write((char)separator) && fmt.space() && base.write(fmt))) {
                return false;
            }
            separator = 44;
        }
        return true;
    }

    private boolean write(CppFormatter fmt) {
        for (Member member : this.members) {
            MemberField field;
            if (!member.isStatic || !(member.element instanceof MemberField) || this.writeStaticFieldInitialization(fmt, field = (MemberField)member.element)) continue;
            return false;
        }
        if (!(this.kind.write(fmt) && fmt.space() && fmt.write(this.getName()) && this.writeBaseClassSpecifierList(fmt) && fmt.openBrace())) {
            return false;
        }
        fmt.enter(this.getName());
        Visibility prevVisibility = this.kind.defaultVisibility;
        for (Member member : this.ctors) {
            if (prevVisibility != member.visibility) {
                if (!member.visibility.write(fmt)) {
                    return false;
                }
                prevVisibility = member.visibility;
            }
            if (member.write(fmt)) continue;
            return false;
        }
        for (Member member : this.members) {
            if (prevVisibility != member.visibility) {
                if (!member.visibility.write(fmt)) {
                    return false;
                }
                prevVisibility = member.visibility;
            }
            if (member.write(fmt)) continue;
            return false;
        }
        fmt.exit();
        return fmt.closeBrace(false) && fmt.terminate();
    }

    @Override
    public boolean write(CppWriter out) {
        switch (this.getGenerationTarget()) {
            case DECL_ONLY: {
                return this.write(out.decl());
            }
            case DEFN_ONLY: {
                return this.write(out.defn());
            }
        }
        for (Member member : this.members) {
            if (!member.isStatic || !(member.element instanceof MemberField)) continue;
            MemberField field = (MemberField)member.element;
            if (this.writeStaticFieldInitialization(out.defn(), field)) continue;
            return false;
        }
        if (!(this.kind.write(out.decl()) && out.decl().space() && out.decl().write(this.getName()) && this.writeBaseClassSpecifierList(out.decl()) && out.decl().openBrace())) {
            return false;
        }
        out.decl().enter(this.getName());
        Visibility prevVisibility = this.kind.defaultVisibility;
        for (Member member : this.ctors) {
            if (prevVisibility != member.visibility) {
                if (!member.visibility.write(out.decl())) {
                    return false;
                }
                prevVisibility = member.visibility;
            }
            if (member.write(out) && out.defn().newline()) continue;
            return false;
        }
        for (Member member : this.members) {
            if (prevVisibility != member.visibility) {
                if (!member.visibility.write(out.decl())) {
                    return false;
                }
                prevVisibility = member.visibility;
            }
            if (member.write(out) && out.defn().newline()) continue;
            return false;
        }
        out.decl().exit();
        return out.decl().closeBrace(false) && out.decl().terminate();
    }

    private boolean writeStaticFieldInitialization(CppFormatter fmt, MemberField field) {
        if (!field.getType().write(fmt, field.getName())) {
            return false;
        }
        if (field.getInitializer() != null) {
            switch (field.getInitKind()) {
                case ASSIGNMENT: {
                    if (fmt.space() && fmt.write('=') && fmt.space() && field.getInitializer().write(fmt)) break;
                    return false;
                }
                case CONSTRUCTOR: {
                    if (fmt.write('(') && fmt.space() && field.getInitializer().write(fmt) && fmt.space() && fmt.write(')')) break;
                    return false;
                }
            }
        }
        return fmt.terminate();
    }

    public static enum Access {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private");

        private final String syntax;

        private Access(String syntax) {
            this.syntax = syntax;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.syntax);
        }
    }

    private class BaseClassSpecifier
    implements IGeneratable {
        private final Access access;
        private final boolean virtual;
        private final NamedElement element;

        public BaseClassSpecifier(Access access, NamedElement element, boolean virtual) {
            this.access = access;
            this.element = element;
            this.virtual = virtual;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.element.getType().addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return this.access.write(fmt) && fmt.space() && (!this.virtual || fmt.write("virtual") && fmt.space()) && fmt.write(this.element.getName());
        }
    }

    public static enum Kind {
        CLASS(Visibility.PRIVATE, "class"),
        STRUCT(Visibility.PUBLIC, "struct");

        public final Visibility defaultVisibility;
        private String syntax;

        private Kind(Visibility v, String syntax) {
            this.defaultVisibility = v;
            this.syntax = syntax;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.syntax);
        }
    }

    private static class Member
    implements IGeneratable,
    IGeneratableElement {
        public final boolean isStatic;
        public final Visibility visibility;
        private final IGeneratableElement element;

        public Member(boolean isStatic, Visibility visibility, IGeneratableElement element) {
            this.isStatic = isStatic;
            this.visibility = visibility;
            this.element = element;
        }

        @Override
        public boolean addDependencies(ElementDependencies deps) {
            return this.element.addDependencies(deps);
        }

        @Override
        public boolean write(CppWriter out) {
            if (!this.isStatic) {
                return this.element.write(out);
            }
            return out.decl().write("static") && out.decl().space() && this.element.write(out);
        }

        private IGeneratable asGeneratable() {
            if (this.element instanceof IGeneratable) {
                return (IGeneratable)((Object)this.element);
            }
            throw new RuntimeException("invalid attempt to use non-default generation on inappropriate element");
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.asGeneratable().addDependencies(deps);
        }

        @Override
        public boolean write(CppFormatter fmt) {
            IGeneratable gen = this.asGeneratable();
            if (!this.isStatic) {
                return gen.write(fmt);
            }
            return fmt.write("static") && fmt.space() && gen.write(fmt);
        }
    }

    public static enum Visibility {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private");

        private final String syntax;

        private Visibility(String syntax) {
            this.syntax = syntax;
        }

        public boolean write(CppFormatter fmt) {
            if (!fmt.decIndent()) {
                return false;
            }
            if (!(fmt.write(this.syntax) && fmt.write(':') && fmt.newline())) {
                fmt.incIndent();
                return false;
            }
            return fmt.incIndent();
        }
    }
}

