/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class MemberAccess
extends Expression {
    private final ElementAccess impl;

    public MemberAccess(Expression container, NamedElement field) {
        this.impl = new NonStaticAccess(container, field);
    }

    public MemberAccess(NamedElement container, NamedElement field) {
        this.impl = new StaticAccess(container, field);
    }

    @Override
    protected Type createType() {
        return this.impl.createType();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return Expression.Precedence.Precedence02;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.impl.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.impl.write(fmt);
    }

    private class NonStaticAccess
    extends ElementAccess {
        private final Expression container;

        public NonStaticAccess(Expression container, NamedElement field) {
            super(field);
            this.container = container;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return this.container.addDependencies(deps) && deps.add(new ElementDependency(this.container.getType().getElement()));
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return this.container.write(fmt, MemberAccess.this) && fmt.write(this.container.getType().isIndirect() ? "->" : ".") && super.write(fmt);
        }
    }

    private static class StaticAccess
    extends ElementAccess {
        private final NamedElement container;

        public StaticAccess(NamedElement container, NamedElement field) {
            super(field);
            this.container = container;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return deps.add(new ElementDependency(this.container.getType().getElement()));
        }

        @Override
        public boolean write(CppFormatter fmt) {
            return fmt.write(this.getName());
        }
    }
}

