/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;

public class ForStatement
extends Statement {
    private final List<Variable> loopVars = new ArrayList<Variable>();
    private final Expression condition;
    private final List<Expression> increments = new ArrayList<Expression>();
    private final CodeBlock body = CodeBlock.defaultBraces();

    public ForStatement(Variable loopVar, Expression condition, Expression increment) {
        if (loopVar != null) {
            this.validateLoopVar(loopVar);
            this.loopVars.add(loopVar);
        }
        this.condition = condition;
        if (increment != null) {
            this.increments.add(increment);
        }
    }

    public boolean addLoopVar(Variable var) {
        this.validateLoopVar(var);
        this.loopVars.add(var);
        return true;
    }

    public void addIncrementExpression(Expression expr) {
        this.increments.add(expr);
    }

    public void add(Statement stmt) {
        this.body.add(stmt);
    }

    private void validateLoopVar(Variable var) throws RuntimeException {
        if (!this.loopVars.isEmpty() && !var.getType().equals(this.loopVars.get(0).getType())) {
            throw new RuntimeException("cannot create loop variables with differing types");
        }
        if (var.getInitializer() == null) {
            throw new RuntimeException("cannot create loop variables without an initializer");
        }
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Variable var : this.loopVars) {
            if (var.addDependencies(deps)) continue;
            return false;
        }
        if (!this.condition.addDependencies(deps)) {
            return false;
        }
        for (Expression expr : this.increments) {
            if (expr.addDependencies(deps)) continue;
            return false;
        }
        return this.body.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        if (!(fmt.write("for") && fmt.write('(') && fmt.space())) {
            return false;
        }
        boolean first = true;
        for (Variable loopVar : this.loopVars) {
            if (first) {
                if (!loopVar.getType().write(fmt, loopVar.getName())) {
                    return false;
                }
                first = false;
            } else if (!(fmt.write(',') && fmt.space() && fmt.write(loopVar.getName()))) {
                return false;
            }
            if (fmt.space() && fmt.write('=') && fmt.space() && loopVar.getInitializer().write(fmt)) continue;
            return false;
        }
        if (!(fmt.write(';') && fmt.space() && this.condition.write(fmt) && fmt.write(';') && fmt.space())) {
            return false;
        }
        first = true;
        for (Expression inc : this.increments) {
            if (first) {
                first = false;
            } else if (!fmt.write(',') || !fmt.space()) {
                return false;
            }
            if (inc.write(fmt)) continue;
            return false;
        }
        return fmt.space() && fmt.write(')') && fmt.newline() && this.body.write(fmt);
    }
}

