/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractUMLRTGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppProjectGenerator;
import org.eclipse.papyrusrt.codegen.utils.ProjectUtils;

public class UMLRTGenerator
extends AbstractUMLRTGenerator {
    public static UMLRTGenerator INSTANCE = new UMLRTGenerator();

    private UMLRTGenerator() {
    }

    public IStatus generate(List<EObject> elements, String top) {
        IStatus status = super.generate(elements, top);
        HashSet<IProject> projects = new HashSet<IProject>();
        for (EObject e : elements) {
            IProject p = this.getProject(e);
            if (p == null) continue;
            projects.add(p);
        }
        for (IProject p : projects) {
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
        return status;
    }

    protected File getModelFolder(EObject eobj) {
        if (eobj == null) {
            return null;
        }
        URI eobjUri = EcoreUtil.getURI((EObject)eobj);
        if (eobjUri == null) {
            return null;
        }
        Path path = new Path(eobjUri.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file == null || !file.exists()) {
            return null;
        }
        IContainer modelContainer = file.getParent();
        if (modelContainer == null || !modelContainer.exists()) {
            return null;
        }
        return modelContainer.getLocation().makeAbsolute().toFile();
    }

    protected File getOutputFolder(EObject eobj) {
        IProject project = this.getProject(eobj);
        IFolder folder = project.getFolder("src");
        try {
            folder.refreshLocal(0, null);
        }
        catch (CoreException e) {
            CodeGenPlugin.error((String)"could not refresh output folder", (Throwable)e);
        }
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                CodeGenPlugin.error((String)"could not create output folder", (Throwable)e);
            }
        }
        return folder.getRawLocation().toFile();
    }

    public IProject getProject(EObject eobj) {
        String projectName = ProjectUtils.getProjectName((EObject)eobj);
        projectName = String.valueOf(projectName) + "_CDTProject";
        String rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            boolean result = new CppProjectGenerator().generate(rootPath, projectName);
            if (!result) {
                CodeGenPlugin.error((String)"Failed to create output project");
                return null;
            }
            try {
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(rootPath) + "/" + projectName + "/.project"));
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                project.create(description, null);
            }
            catch (CoreException coreException) {
                CodeGenPlugin.error((String)"Failed to create output project");
            }
        }
        if (!project.isOpen()) {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                CodeGenPlugin.error((String)"Failed to open project");
            }
        }
        return project;
    }
}

