/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.propertytester;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class UMLRTPropertyTester
extends PropertyTester {
    private static final String STEREOTYPE_PROPERTY = "stereotype";
    private static final String EOBJECTTYPE_PROPERTY = "eobjecttype";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        EObject eobj;
        Object element = null;
        if (receiver instanceof List) {
            element = ((List)receiver).get(0);
        }
        if ((eobj = EMFHelper.getEObject(element)) instanceof Element && STEREOTYPE_PROPERTY.equals(property)) {
            Stereotype st = ((Element)eobj).getAppliedStereotype((String)expectedValue);
            return st != null;
        }
        if (eobj != null && EOBJECTTYPE_PROPERTY.equals(property)) {
            boolean result = false;
            Class<?>[] classArray = eobj.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clz = classArray[n2];
                result = clz.getSimpleName().equals(expectedValue);
                if (result) {
                    return result;
                }
                ++n2;
            }
            return eobj.getClass().getSimpleName().equals(expectedValue);
        }
        return false;
    }
}

