/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.papyrusrt.codegen.utils.UML2Util;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Capsule;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Protocol;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.ProtocolContainer;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTConnector;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTRedefinedElement;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class UMLRealTimeProfileUtil {
    private UMLRealTimeProfileUtil() {
    }

    public static boolean isCapsule(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::Capsule");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static Capsule getCapsule(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::Capsule");
        if (s == null) {
            return null;
        }
        return (Capsule)el.getStereotypeApplication(s);
    }

    public static boolean isCapsulePart(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::CapsulePart");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static CapsulePart getCapsulePart(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::CapsulePart");
        if (s == null) {
            return null;
        }
        return (CapsulePart)el.getStereotypeApplication(s);
    }

    public static boolean isProtocol(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::Protocol");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static Protocol getProtocol(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::Protocol");
        if (s == null) {
            return null;
        }
        return (Protocol)el.getStereotypeApplication(s);
    }

    public static Collaboration getProtocolCollaboration(Package protocolPackage) {
        if (!UMLRealTimeProfileUtil.isProtocolContainer((Element)protocolPackage)) {
            return null;
        }
        Collaboration collaboration = null;
        for (Element element : protocolPackage.getOwnedElements()) {
            if (!(element instanceof Collaboration) || !UMLRealTimeProfileUtil.isProtocol(element)) continue;
            collaboration = (Collaboration)element;
            break;
        }
        return collaboration;
    }

    public static boolean isRTPort(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::RTPort");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static RTPort getRTPort(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::RTPort");
        if (s == null) {
            return null;
        }
        return (RTPort)el.getStereotypeApplication(s);
    }

    public static boolean isRTConnector(Connector connector) {
        Stereotype s = connector.getApplicableStereotype("UMLRealTime::RTConnector");
        if (s != null) {
            return connector.isStereotypeApplied(s);
        }
        return false;
    }

    public static RTConnector getRTConnector(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::RTConnector");
        if (s == null) {
            return null;
        }
        return (RTConnector)el.getStereotypeApplication(s);
    }

    public static boolean isProtocolContainer(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::ProtocolContainer");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static ProtocolContainer getProtocolContainer(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::ProtocolContainer");
        if (s == null) {
            return null;
        }
        return (ProtocolContainer)el.getStereotypeApplication(s);
    }

    public static boolean isRTRedefinedElement(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::RTRedefinedElement");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static RTRedefinedElement getRTRedefinedElement(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::RTRedefinedElement");
        if (s == null) {
            return null;
        }
        return (RTRedefinedElement)el.getStereotypeApplication(s);
    }

    public static boolean isRTMessageSet(Element el) {
        Stereotype s = el.getApplicableStereotype("UMLRealTime::RTMessageSet");
        if (s != null) {
            return el.isStereotypeApplied(s);
        }
        return false;
    }

    public static RTMessageSet getRTMessageSet(Element el) {
        Stereotype s = el.getAppliedStereotype("UMLRealTime::RTMessageSet");
        if (s == null) {
            return null;
        }
        return (RTMessageSet)el.getStereotypeApplication(s);
    }

    private static Iterable<Operation> getProtocolMessagesFromRTMessageSets(Iterable<Interface> interfaces, RTMessageKind messageKind, boolean includeInOut) {
        TreeSet<NamedElement> operations = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        if (interfaces != null) {
            for (Interface iface : interfaces) {
                RTMessageKind kind;
                RTMessageSet rtMessageSet = UMLRealTimeProfileUtil.getRTMessageSet((Element)iface);
                if (rtMessageSet == null || (kind = rtMessageSet.getRtMsgKind()) != messageKind && (!includeInOut || kind != RTMessageKind.IN_OUT)) continue;
                operations.addAll((Collection<NamedElement>)iface.getOwnedOperations());
            }
        }
        return operations;
    }

    public static Iterable<Operation> getProtocolMessages(Collaboration collaboration, RTMessageKind kind) {
        switch (kind) {
            case IN: {
                return UMLRealTimeProfileUtil.getInProtocolMessages(collaboration, false);
            }
            case OUT: {
                return UMLRealTimeProfileUtil.getOutProtocolMessages(collaboration, false);
            }
            case IN_OUT: {
                return UMLRealTimeProfileUtil.getInOutProtocolMessages(collaboration);
            }
        }
        return null;
    }

    public static Iterable<Operation> getInProtocolMessages(Collaboration collaboration, boolean includeInOut) {
        return UMLRealTimeProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyRealizedInterfaces(), RTMessageKind.IN, true);
    }

    public static Iterable<Operation> getOutProtocolMessages(Collaboration collaboration, boolean includeInOut) {
        return UMLRealTimeProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyUsedInterfaces(), RTMessageKind.OUT, true);
    }

    public static Iterable<Operation> getInOutProtocolMessages(Collaboration collaboration) {
        return UMLRealTimeProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyRealizedInterfaces(), RTMessageKind.IN_OUT, false);
    }

    public static boolean isSignal(Element el) {
        if (el != null && el instanceof Operation) {
            Operation op = (Operation)el;
            Interface iface = op.getInterface();
            return iface != null && UMLRealTimeProfileUtil.isRTMessageSet((Element)iface);
        }
        return false;
    }

    public static Package getProtocol(Port umlPort) {
        Type type = umlPort.getType();
        if (type == null) {
            return null;
        }
        Package pkg = type.getPackage();
        if (pkg == null) {
            return null;
        }
        return UMLRealTimeProfileUtil.isProtocolContainer((Element)pkg) ? pkg : null;
    }

    public static Iterable<Property> getCapsuleParts(EncapsulatedClassifier classifier) {
        TreeSet<NamedElement> parts = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        for (Property attr : classifier.getOwnedAttributes()) {
            if (!UMLRealTimeProfileUtil.isCapsulePart((Element)attr)) continue;
            parts.add((NamedElement)attr);
        }
        return parts;
    }

    public static Iterable<Port> getRTPorts(EncapsulatedClassifier classifier) {
        TreeSet<NamedElement> ports = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        for (Port port : classifier.getOwnedPorts()) {
            if (!UMLRealTimeProfileUtil.isRTPort((Element)port) || UMLRealTimeProfileUtil.getProtocol(port) == null) continue;
            ports.add((NamedElement)port);
        }
        return ports;
    }

    public static Iterable<Port> getAllRTPorts(Class klass) {
        TreeSet<NamedElement> allPorts = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        if (klass != null) {
            for (Port p : UMLRealTimeProfileUtil.getRTPorts((EncapsulatedClassifier)klass)) {
                allPorts.add((NamedElement)p);
            }
            Class parent = UMLRealTimeProfileUtil.getBaseRTCapsule(klass);
            if (parent != null) {
                for (Port p : UMLRealTimeProfileUtil.getAllRTPorts(parent)) {
                    if (UMLRealTimeProfileUtil.redefines(klass, p)) continue;
                    allPorts.add((NamedElement)p);
                }
            }
        }
        return allPorts;
    }

    public static Iterable<Connector> getRTConnectors(EncapsulatedClassifier classifier) {
        TreeSet<NamedElement> connectors = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        for (Connector connector : classifier.getOwnedConnectors()) {
            if (!UMLRealTimeProfileUtil.isRTConnector(connector)) continue;
            connectors.add((NamedElement)connector);
        }
        return connectors;
    }

    public static Iterable<Connector> getAllRTConnectors(Class klass) {
        TreeSet<NamedElement> allConnectors = new TreeSet<NamedElement>(new UML2Util.NameComparator());
        if (klass != null) {
            for (Connector c : UMLRealTimeProfileUtil.getRTConnectors((EncapsulatedClassifier)klass)) {
                allConnectors.add((NamedElement)c);
            }
            Class parent = UMLRealTimeProfileUtil.getBaseRTCapsule(klass);
            if (parent != null) {
                for (Connector c : UMLRealTimeProfileUtil.getAllRTConnectors(parent)) {
                    if (UMLRealTimeProfileUtil.redefines(klass, c)) continue;
                    allConnectors.add((NamedElement)c);
                }
            }
        }
        return allConnectors;
    }

    private static Class getBaseRTCapsule(Class klass) {
        if (klass != null && !klass.getSuperClasses().isEmpty()) {
            for (Class kls : klass.getSuperClasses()) {
                if (!UMLRealTimeProfileUtil.isCapsule((Element)kls)) continue;
                return kls;
            }
        }
        return null;
    }

    private static boolean redefines(Class klass, Port port) {
        if (port == null) {
            return false;
        }
        for (Port p : UMLRealTimeProfileUtil.getRedefinedPorts(klass)) {
            if (p != port && !port.equals(p)) continue;
            return true;
        }
        return false;
    }

    private static boolean redefines(Class klass, Connector connector) {
        if (connector == null) {
            return false;
        }
        for (Connector c : UMLRealTimeProfileUtil.getRedefinedConnectors(klass)) {
            if (c != connector && !connector.equals(c)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<Port> getRedefinedPorts(Class klass) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : UMLRealTimeProfileUtil.getPortRedefinitions(klass)) {
            Port redefined = (Port)p.getRedefinedPorts().get(0);
            ports.add(redefined);
        }
        return ports;
    }

    private static Iterable<Port> getPortRedefinitions(Class klass) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : UMLRealTimeProfileUtil.getRTPorts((EncapsulatedClassifier)klass)) {
            if (p.getRedefinedPorts() == null || p.getRedefinedPorts().isEmpty()) continue;
            ports.add(p);
        }
        return ports;
    }

    private static Iterable<Connector> getRedefinedConnectors(Class klass) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Connector c : UMLRealTimeProfileUtil.getConnectorRedefinitions(klass)) {
            Connector redefined = (Connector)c.getRedefinedConnectors().get(0);
            connectors.add(redefined);
        }
        return connectors;
    }

    private static Iterable<Connector> getConnectorRedefinitions(Class klass) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Connector c : UMLRealTimeProfileUtil.getRTConnectors((EncapsulatedClassifier)klass)) {
            if (c.getRedefinedConnectors() == null || c.getRedefinedConnectors().isEmpty()) continue;
            connectors.add(c);
        }
        return connectors;
    }
}

