/*******************************************************************************
 * Copyright (c) 2015 Zeligsoft (2009) Limited and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.papyrusrt.codegen.utils

import java.util.List

/**
 * @author eposse
 */
class GeneralUtil
{

    static def <T> void addIfNotNull(List<T> list, T obj)
    {
        if (list !== null && obj !== null)
        {
            list.add( obj )
        }
    }

    static def <T> void addIfNotPresent(List<T> list, T obj)
    {
        if (list !== null && obj !== null && !list.contains(obj))
        {
            list.add( obj )
        }
    }

}