/*******************************************************************************
* Copyright (c) 2015 Zeligsoft (2009) Limited  and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.papyrusrt.codegen.xtumlrt.trans

import org.eclipse.emf.ecore.EObject
import org.eclipse.papyrusrt.codegen.xtumlrt.trans.GenerationProperties
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement
import org.eclipse.emf.ecore.EEnumLiteral

class RTCppGenerationProperties extends GenerationProperties
{

    static val ALL_CLASS_STEREOTYPES =
    #[
        "ClassProperties",
        "PassiveClassProperties",
        "CapsuleProperties"
    ]

    static val ALL_CPP_FILE_STEREOTYPES =
    #[
        "ClassProperties",
        "PassiveClassProperties",
        "CapsuleProperties",
        "EnumerationProperties",
        "CppFileProperties"
    ]

    static val ALL_FILE_STEREOTYPES =
    #[
        "PassiveClassProperties",
        "CapsuleProperties",
        "FileGenerationProperties"
    ]

    static val ALL_GENERATION_STEREOTYPES =
    #[
        "PassiveClassProperties",
        "EnumerationProperties",
        "GenerationProperties"
    ]

    static enum AttributeKind
    {
        MEMBER,
        GLOBAL,
        MUTABLE_MEMBER,
        DEFINE
    }

    static val ATTR_KIND_EENUMS =
    #[
        AttributeKind.MEMBER,
        AttributeKind.GLOBAL,
        AttributeKind.MUTABLE_MEMBER,
        AttributeKind.DEFINE
    ]

    static enum AttributeInitializationKind
    {
        ASSIGNMENT,
        CONSTANT,
        CONSTRUCTOR
    }

    static val ATTR_INIT_KIND_EENUMS =
    #[
        AttributeInitializationKind.ASSIGNMENT,
        AttributeInitializationKind.CONSTANT,
        AttributeInitializationKind.CONSTRUCTOR
    ]

    static enum OperationKind
    {
        MEMBER,
        FRIEND,
        GLOBAL
    }

    static val OP_KIND_EENUMS =
    #[
        OperationKind.MEMBER,
        OperationKind.FRIEND,
        OperationKind.GLOBAL
    ]

    static enum DependencyKind
    {
        FORWARD_REFERENCE,
        INCLUSION,
        NONE
    }

    static val DEP_KIND_EENUMS =
    #[
        DependencyKind.FORWARD_REFERENCE,
        DependencyKind.INCLUSION,
        DependencyKind.NONE
    ]

    static def getAttributeProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isAttributeProperties ]
    }

    static def getAttributePropKind( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "AttributeProperties", "kind" ) as EEnumLiteral
        if (eEnumLiteral === null) null else ATTR_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getAttributePropInitialization( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "AttributeProperties", "initialization" ) as EEnumLiteral
        if (eEnumLiteral === null) null else ATTR_INIT_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getAttributePropVolatile( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "volatile" ) as Boolean
    }

    static def getAttributePropType( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "type" ) as String
    }

    static def getAttributePropSize( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "size" ) as String
    }

    static def getAttributePropPointsTo( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToType" ) as Boolean
    }

    static def getAttributePropPointsToConst( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToConstType" ) as Boolean
    }

    static def getAttributePropPointsToVolatile( CommonElement element )
    {
        getProperty( element, "AttributeProperties", "pointsToVolatileType" ) as Boolean
    }

    static def getClassProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isClassProperties ]
    }

    static def getClassPropPrivateDeclarations( CommonElement element )
    {
        getProperty( element, ALL_CLASS_STEREOTYPES, "privateDeclarations" ) as String
    }

    static def getClassPropProtectedDeclarations( CommonElement element )
    {
        getProperty( element, ALL_CLASS_STEREOTYPES, "protectedDeclarations" ) as String
    }

    static def getClassPropPublicDeclarations( CommonElement element )
    {
        getProperty( element, ALL_CLASS_STEREOTYPES, "publicDeclarations" ) as String
    }

    static def getCppFileProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isCppFileProperties ]
    }

    static def getCppFileHeaderPreface( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "headerPreface" ) as String
    }

    static def getCppFileHeaderEnding( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "headerEnding" ) as String
    }

    static def getCppFileImplementationPreface( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "implementationPreface" ) as String
    }

    static def getCppFileImplementationEnding( CommonElement element )
    {
        getProperty( element, ALL_CPP_FILE_STEREOTYPES, "implementationEnding" ) as String
    }

    static def getDependencyProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isDependencyProperties ]
    }

    static def getDependencyPropKindInHeader( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "DependencyProperties", "KindInHeader" ) as EEnumLiteral
        if (eEnumLiteral === null) null else DEP_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getDependencyPropKindInImplementation( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "DependencyProperties", "KindInImplementation" ) as EEnumLiteral
        if (eEnumLiteral === null) null else DEP_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getFileGenerationProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isFileGenerationProperties ]
    }

    static def getFileGenerationPropGenerateHeader( CommonElement element )
    {
        getProperty( element, ALL_FILE_STEREOTYPES, "generateHeader" ) as Boolean
    }

    static def getFileGenerationPropGenerateImplementation( CommonElement element )
    {
        getProperty( element, ALL_FILE_STEREOTYPES, "generateImplementation" ) as Boolean
    }

    static def getGeneralizationProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isGeneralizationProperties ]
    }

    static def getGeneralizationPropVirtual( CommonElement element )
    {
        getProperty( element, "GeneralizationProperties", "virtual" ) as Boolean
    }

    static def getGenerationProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isGenerationProperties ]
    }

    static def getGenerationPropGenerate( CommonElement element )
    {
        getProperty( element, ALL_GENERATION_STEREOTYPES, "generate" ) as Boolean
    }

    static def getOperationProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isOperationProperties ]
    }

    static def getOperationPropKind( CommonElement element )
    {
        val eEnumLiteral = getProperty( element, "OperationProperties", "kind" ) as EEnumLiteral
        if (eEnumLiteral === null) null else OP_KIND_EENUMS.get( eEnumLiteral.value )
    }

    static def getOperationPropInline( CommonElement element )
    {
        getProperty( element, "OperationProperties", "Inline" ) as Boolean
    }

    static def getOperationPropPolymorphic( CommonElement element )
    {
        getProperty( element, "OperationProperties", "Polymorphic" ) as Boolean
    }

    static def getOperationPropGenDef( CommonElement element )
    {
        getProperty( element, "OperationProperties", "generateDefinition" ) as Boolean
    }

    static def getParameterProperties( CommonElement element )
    {
        element?.allGenProperties?.findFirst [ it.isParameterProperties ]
    }

    static def getParameterPropType( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "type" ) as String
    }

    static def getParameterPropPointsTo( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToType" ) as Boolean
    }

    static def getParameterPropPointsToConst( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToConst" ) as Boolean
    }

    static def getParameterPropPointsToVolatile( CommonElement element )
    {
        getProperty( element, "ParameterProperties", "pointsToVolatile" ) as Boolean
    }

    static def hasAttributeKind( CommonElement element, AttributeKind expectedKind )
    {
        val kind = element?.getAttributePropKind
        kind !== null && kind == expectedKind
    }

    static def hasAttributeKindMember( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.MEMBER )
    }

    static def hasAttributeKindGlobal( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.GLOBAL )
    }

    static def hasAttributeKindMutableMember( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.MUTABLE_MEMBER )
    }

    static def hasAttributeKindDefine( CommonElement element )
    {
        element.hasAttributeKind( AttributeKind.DEFINE )
    }

    static def hasOperationKind( CommonElement element, OperationKind expectedKind )
    {
        val kind = element?.getOperationPropKind
        kind !== null && kind == expectedKind
    }

    static def hasOperationKindMember( CommonElement element )
    {
        element.hasOperationKind( OperationKind.MEMBER )
    }

    static def hasOperationKindFriend( CommonElement element )
    {
        element.hasOperationKind( OperationKind.FRIEND )
    }

    static def hasOperationKindGlobal( CommonElement element )
    {
        element.hasOperationKind( OperationKind.GLOBAL )
    }

    static def isAttributeProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "AttributeProperties"
    }

    static def isClassProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "ClassProperties"
    }

    static def isCppFileProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "CppFileProperties"
    }

    static def isDependencyProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "DependencyProperties"
    }

    static def isFileGenerationProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "FileGenerationProperties"
    }

    static def isGeneralizationProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "GeneralizationProperties"
    }

    static def isGenerationProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "GenerationProperties"
    }

    static def isOperationProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "OperationProperties"
    }

    static def isParameterProperties( EObject stereotypeApplication )
    {
        stereotypeApplication.eClass.name == "ParameterProperties"
    }

}