/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtocolBehaviourFeatureKind implements Enumerator
{
    IN(0, "IN", "IN"),
    OUT(1, "OUT", "OUT"),
    INOUT(2, "INOUT", "INOUT");

    public static final String copyright = "Copyright (c) 2014-2015 Zeligsoft (2009) Limited, IncQueryLabs Limited and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n";
    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    private static final ProtocolBehaviourFeatureKind[] VALUES_ARRAY;
    public static final List<ProtocolBehaviourFeatureKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProtocolBehaviourFeatureKind[]{IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProtocolBehaviourFeatureKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolBehaviourFeatureKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolBehaviourFeatureKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolBehaviourFeatureKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolBehaviourFeatureKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
        }
        return null;
    }

    private ProtocolBehaviourFeatureKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

