/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Celine Janssens (ALL4TEC) celine.janssens@all4tec.net  - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.PropertyPartEditPartCN;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.providers.RTEditPartProvider;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies.CanonicalPortDisplayEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies.RTCustomDiagramDragDropEditPolicy;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editpolicies.RTSideAffixedNodesCreationEditPolicy;

/**
 * This Class redefines the PropertyPartEditPartCN for the Real Time Context
 * This editPart is used to control the CapsulePart.
 * 
 * @see {@link RTEditPartProvider}
 * 
 * @author Céline JANSSENS
 *
 */
public class RTPropertyPartEditPart extends PropertyPartEditPartCN {


	/**
	 * Constructor.
	 *
	 * @param view
	 */
	public RTPropertyPartEditPart(View view) {
		super(view);

	}

	/**
	 * @see org.eclipse.papyrus.uml.diagram.composite.edit.parts.PropertyPartEditPartCN#createDefaultEditPolicies()
	 *
	 */
	@Override
	protected void createDefaultEditPolicies() {

		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.CREATION_ROLE, new RTSideAffixedNodesCreationEditPolicy());
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE, new RTCustomDiagramDragDropEditPolicy());
		installEditPolicy(CanonicalPortDisplayEditPolicy.CANONICAL_PORT_DISPLAY_ROLE, new CanonicalPortDisplayEditPolicy());

	}

}
