/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.copy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;

public class UmlRTPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new UmlRTPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "Uml RT Paste Strategy";
    }

    public String getID() {
        return "org.eclipse.papyrusrt.umlrt.tooling.diagram.common.UMLRTPasteStrategy";
    }

    public String getDescription() {
        return "Copy Call event in model explorer";
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("UML-RT : Duplicate Call event when copy/paste an operation");
        Command pasteOperationCommand = this.getPasteOperationCommand(targetOwner, papyrusClipboard);
        Command createCallEventCommand = this.getCreateCallEventCommand(targetOwner, papyrusClipboard);
        compoundCommand.append(pasteOperationCommand);
        compoundCommand.append(createCallEventCommand);
        if (compoundCommand.isEmpty()) {
            compoundCommand = null;
        }
        return compoundCommand;
    }

    private Command getPasteOperationCommand(EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand pasteCommand = new CompoundCommand("Paste Operation Command");
        if (papyrusClipboard.size() > 0) {
            Iterator iter = papyrusClipboard.iterateOnSource();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof Operation)) continue;
                Operation originalOperation = (Operation)object;
                Operation internalOperation = (Operation)papyrusClipboard.getCopyFromSource((EObject)originalOperation);
                Operation newOperation = (Operation)papyrusClipboard.getInternalClipboardToTargetCopy().get(internalOperation);
                RTMessageKind kind = this.getRTAdditionalData(papyrusClipboard, internalOperation).getMessageKind();
                EObject realTarget = this.getRealTarget(kind, targetOwner);
                MoveRequest moveRequest = new MoveRequest(realTarget, (EObject)newOperation);
                pasteCommand.append(this.getEditCommand((IEditCommandRequest)moveRequest, realTarget));
            }
        }
        return pasteCommand;
    }

    private Command getCreateCallEventCommand(EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand();
        UmlRTClipboardAdditionalData additionalData = null;
        for (Object object : papyrusClipboard) {
            EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
            if (target == null || !(target instanceof Operation) || !(targetOwner instanceof Collaboration)) continue;
            Package nearestPackage = ((Collaboration)targetOwner).getNearestPackage();
            additionalData = this.getRTAdditionalData(papyrusClipboard, object);
            if (additionalData == null) continue;
            CallEvent callEvent = additionalData.getDuplicateCallEvent();
            Command command = this.getMoveCallEventCommand(callEvent, nearestPackage, (Operation)target);
            compoundCommand.append(command);
        }
        return compoundCommand;
    }

    private EObject getRealTarget(RTMessageKind originalKind, EObject targetOwner) {
        Interface messageSet = null;
        if (targetOwner instanceof Collaboration && originalKind != null) {
            Package container = ((Collaboration)targetOwner).getNearestPackage();
            messageSet = ProtocolContainerUtils.getMessageSet((Package)container, (RTMessageKind)originalKind);
        }
        return messageSet;
    }

    protected UmlRTClipboardAdditionalData getRTAdditionalData(PapyrusClipboard<Object> papyrusClipboard, Object operation) {
        UmlRTClipboardAdditionalData additional = null;
        Map additionnalData = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        Object umlRTAdditionnalData = additionnalData.get(operation);
        if (umlRTAdditionnalData instanceof UmlRTClipboardAdditionalData) {
            additional = (UmlRTClipboardAdditionalData)umlRTAdditionnalData;
        }
        return additional;
    }

    protected Command getMoveCallEventCommand(CallEvent targetCallEvent, Package container, Operation operation) {
        Command callEventMoveCommand = null;
        if (targetCallEvent != null) {
            targetCallEvent.setOperation(operation);
            MoveRequest moveRequest = new MoveRequest((EObject)container, (EObject)targetCallEvent);
            callEventMoveCommand = this.getEditCommand((IEditCommandRequest)moveRequest, container);
        }
        if (!callEventMoveCommand.canExecute()) {
            callEventMoveCommand = null;
        }
        return callEventMoveCommand;
    }

    protected Command getEditCommand(IEditCommandRequest request, Object objectProvider) {
        ICommand editCommand;
        Command command = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)objectProvider);
        if (provider != null && (editCommand = provider.getEditCommand(request)).canExecute()) {
            command = GMFtoEMFCommandWrapper.wrap((ICommand)editCommand);
        }
        return command;
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, UmlRTClipboardAdditionalData> mapCopyToClipboardAdditionalData = new HashMap<Object, UmlRTClipboardAdditionalData>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            CallEvent callEvent;
            EObject eObjectSource = (EObject)iterator.next();
            if (!(eObjectSource instanceof Operation) || (callEvent = MessageUtils.getCallEvent((Operation)((Operation)eObjectSource))) == null) continue;
            UmlRTClipboardAdditionalData umlRTClipboardAdditionalData = new UmlRTClipboardAdditionalData(callEvent, RTMessageUtils.getMessageKind((Object)eObjectSource));
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToClipboardAdditionalData.put(copy, umlRTClipboardAdditionalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToClipboardAdditionalData);
    }

    protected class UmlRTClipboardAdditionalData
    implements IClipboardAdditionalData {
        protected CallEvent callEvent;
        protected RTMessageKind messagekind;

        public UmlRTClipboardAdditionalData(CallEvent callEvent, RTMessageKind kind) {
            this.callEvent = callEvent;
            this.messagekind = kind;
        }

        public CallEvent getDuplicateCallEvent() {
            return this.duplicateCallEvent(this.callEvent);
        }

        public RTMessageKind getMessageKind() {
            return this.messagekind;
        }

        protected CallEvent duplicateCallEvent(CallEvent callEvent) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copy((EObject)callEvent);
            copier.copyReferences();
            EObject copy = (EObject)copier.get((Object)callEvent);
            if (copy instanceof CallEvent) {
                return (CallEvent)copy;
            }
            return null;
        }
    }
}

