package org.eclipse.papyrusrt.umlrt.tooling.ui.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElementFactory;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortUtils;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Activator;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class UMLRTExtModelElementFactory extends UMLModelElementFactory {

	@Override
	protected UMLModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
		EObject source = EMFHelper.getEObject(sourceElement);
		UMLModelElement modelElement = null;
		if (source != null) {
			// should check here for RT specific Elements?
			if (source instanceof Collaboration && ProtocolUtils.isProtocol((Collaboration) source)) {
				modelElement = new UMLRTExtModelElement(source);
			} else if (source instanceof Port && RTPortUtils.isRTPort(source)) {
				modelElement = new UMLRTExtModelElement(source);
			} else if (source instanceof Property && CapsulePartUtils.isCapsulePart((Property) source)) {
				modelElement = new UMLRTExtModelElement(source);
			} else if (source instanceof Interface && MessageSetUtils.isRTMessageSet((Interface) source)) {
				modelElement = new UMLRTExtModelElement(source);
			} else {
				modelElement = super.doCreateFromSource(sourceElement, context);
			}
		} else {
			Activator.log.warn("Unable to resolve the selected element to an EObject"); //$NON-NLS-1$
		}

		return modelElement;
	}

}
