/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.internal.ArtifactGenerator;
import org.eclipse.papyrusrt.codegen.cpp.internal.CapsuleGenerator;
import org.eclipse.papyrusrt.codegen.cpp.internal.EclipseGeneratorManager;
import org.eclipse.papyrusrt.codegen.cpp.internal.EmptyStateMachineGenerator;
import org.eclipse.papyrusrt.codegen.cpp.internal.EnumGenerator;
import org.eclipse.papyrusrt.codegen.cpp.internal.ProtocolGenerator;
import org.eclipse.papyrusrt.codegen.cpp.internal.SerializableClassGenerator;
import org.eclipse.papyrusrt.xtumlrt.common.Artifact;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;

public class GeneratorManager {
    private static GeneratorManager INSTANCE;

    public static void setInstance(GeneratorManager instance) {
        if (INSTANCE != null) {
            throw new RuntimeException("Invalid attempt to replace GeneratorManager");
        }
        INSTANCE = instance;
    }

    public static GeneratorManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EclipseGeneratorManager();
        }
        return INSTANCE;
    }

    public AbstractCppGenerator getGenerator(CppCodeGenerator.Kind kind, CppCodePattern cpp, NamedElement element, NamedElement context) {
        switch (kind) {
            case BasicClass: {
                if (!(element instanceof StructuredType)) break;
                return new SerializableClassGenerator(cpp, (StructuredType)element);
            }
            case Enum: {
                if (!(element instanceof Enumeration)) break;
                return new EnumGenerator(cpp, (Enumeration)element);
            }
            case Protocol: {
                if (!(element instanceof Protocol)) break;
                return new ProtocolGenerator(cpp, (Protocol)element);
            }
            case Capsule: {
                if (!(element instanceof Capsule)) break;
                return new CapsuleGenerator(cpp, (Capsule)element);
            }
            case EmptyStateMachine: {
                return new EmptyStateMachineGenerator(cpp, element);
            }
            case Artifact: {
                return new ArtifactGenerator(cpp, (Artifact)element);
            }
        }
        CodeGenPlugin.error((String)("ignoring request for unknown generator " + kind.id));
        throw new RuntimeException("cannot find generator id " + kind.id);
    }
}

