/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.GeneratorManager;
import org.eclipse.papyrusrt.codegen.cpp.internal.GeneratorDescriptor;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;

public class EclipseGeneratorManager
extends GeneratorManager {
    private static final String EXTENSION_POINT = "generator";
    private Map<String, GeneratorDescriptor> generators = EclipseGeneratorManager.loadExtensions();

    private static Map<String, GeneratorDescriptor> loadExtensions() {
        IConfigurationElement[] elements;
        HashMap<String, GeneratorDescriptor> generators = new HashMap<String, GeneratorDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrusrt.codegen.cpp", EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            GeneratorDescriptor desc = new GeneratorDescriptor(element);
            if (generators.containsKey(desc.getType())) {
                GeneratorDescriptor gen = (GeneratorDescriptor)generators.get(desc.getType());
                if (desc.getPriority().getValue() > gen.getPriority().getValue()) {
                    generators.put(desc.getType(), desc);
                    CodeGenPlugin.info((String)("Ignoring lower priority generator for " + gen.getType() + ":" + gen.getFactory().toString()));
                } else {
                    CodeGenPlugin.info((String)("Ignoring lower priority generator for " + desc.getType() + ":" + desc.getFactory().toString()));
                }
            } else {
                generators.put(desc.getType(), desc);
            }
            ++n2;
        }
        return generators;
    }

    @Override
    public AbstractCppGenerator getGenerator(CppCodeGenerator.Kind kind, CppCodePattern cpp, NamedElement element, NamedElement context) {
        GeneratorDescriptor desc = this.generators.get(kind.id);
        if (desc != null) {
            return desc.getFactory().create(cpp, element, context);
        }
        return super.getGenerator(kind, cpp, element, context);
    }
}

