/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppGenerator;
import org.eclipse.uml2.uml.util.UMLUtil;

public class GeneratorDescriptor {
    private static final String Attr_Type = "type";
    private static final String Attr_Class = "class";
    private static final String Attr_Priority = "priority";
    private final IConfigurationElement element;
    private String type;
    private Priority priority;
    private AbstractCppGenerator.Factory factory;

    public GeneratorDescriptor(IConfigurationElement element) {
        this.element = element;
        this.type = element.getAttribute(Attr_Type);
        String pt = element.getAttribute(Attr_Priority);
        if (UMLUtil.isEmpty((String)pt)) {
            pt = "Low";
        }
        switch (pt) {
            case "Low": {
                this.priority = Priority.Low;
                break;
            }
            case "Medium": {
                this.priority = Priority.Medium;
                break;
            }
            case "High": {
                this.priority = Priority.High;
                break;
            }
            case "Highest": {
                this.priority = Priority.Highest;
                break;
            }
            default: {
                this.priority = Priority.Low;
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public Priority getPriority() {
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCppGenerator.Factory getFactory() {
        if (this.factory == null) {
            GeneratorDescriptor generatorDescriptor = this;
            synchronized (generatorDescriptor) {
                if (this.factory == null) {
                    try {
                        this.factory = (AbstractCppGenerator.Factory)this.element.createExecutableExtension(Attr_Class);
                    }
                    catch (CoreException e) {
                        String id = String.valueOf(this.element.getDeclaringExtension().getNamespaceIdentifier()) + '.' + this.element.getDeclaringExtension().getSimpleIdentifier();
                        CodeGenPlugin.error((String)("Error in class attribute of " + id), (Throwable)e);
                    }
                }
            }
        }
        return this.factory;
    }

    public static enum Priority {
        Low(1),
        Medium(2),
        High(3),
        Highest(4);

        private int priority;

        private Priority(int p) {
            this.priority = p;
        }

        int getValue() {
            return this.priority;
        }
    }
}

